/**
 * @(#)ChangeFlowController.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.web.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.netease.mail.yanxuan.change.biz.config.TitleConfig;
import com.netease.mail.yanxuan.change.biz.meta.AjaxResult;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
@RestController
@RequestMapping("/change/flow")
public class ChangeFlowController {

    @Autowired
    private ChangeFlowService changeFlowService;

    /**
     * 变更工单详情查询
     * @return
     */
    @GetMapping("/detail")
    public AjaxResult<Void> detail() {

        return AjaxResult.success();
    }

    /**
     * 变更工单列表查询
     * @return
     */
    @GetMapping("/query")
    public AjaxResult<Void> query() {
        return AjaxResult.success();
    }

    /**
     * 返回提示文案
     * @return
     */
    @GetMapping("/title")
    public AjaxResult<TitleConfig> title() {
        return AjaxResult.success(changeFlowService.getTitleConfig());
    }

    /**
     * 发起变更
     * @return
     */
    @PostMapping("/create")
    public AjaxResult<Boolean> create() {
        return AjaxResult.success();
    }

    /**
     * 变更工单提交
     * @return
     */
    @PostMapping("/submit")
    public AjaxResult<Boolean> submit() {
        return AjaxResult.success();
    }

    /**
     * 工单转交
     * @return
     */
    @PostMapping("/deliver")
    public AjaxResult<Boolean> deliver() {
        return AjaxResult.success();
    }

    /**
     * 工单取消
     * @return
     */
    @GetMapping("/cancel")
    public AjaxResult<Void> cancel() {

        return AjaxResult.success();
    }

    /**
     * 引用变更工单
     * @return
     */
    @GetMapping("/quote")
    public AjaxResult<Void> quote() {

        return AjaxResult.success();
    }


    /**
     * 导出变更
     * @return
     */
    @PostMapping("/export")
    public AjaxResult<Void> export() {

        return AjaxResult.success();
    }
}