package com.netease.mail.yanxuan.change.biz.biz;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowExecService;
import com.netease.mail.yanxuan.change.biz.service.ChangeSubFlowService;
import com.netease.mail.yanxuan.change.biz.service.rpc.FlowService;
import com.netease.mail.yanxuan.change.common.bean.CommonConstants;
import com.netease.mail.yanxuan.change.common.bean.RequestLocalBean;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.enums.ChangeFlowEnum;
import com.netease.mail.yanxuan.change.common.enums.FlowOperationTypeEnum;
import com.netease.mail.yanxuan.change.common.enums.FlowxOperationEnum;
import com.netease.mail.yanxuan.change.common.util.DateUtils;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeSubFlowCreateReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeSubFlowSubmitReq;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.FlowDataDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.flow.FlowCreateReqDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import javax.validation.Valid;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Component
@Slf4j
public class ChangeSubFlowBiz {

    @Autowired
    private ChangeSubFlowService changeSubFlowService;

    @Autowired
    private FlowService flowService;

    @Autowired
    private ChangeFlowExecService changeFlowExecService;


    public String createAndSubmit(@Valid ChangeSubFlowCreateReq changeSubFlowCreateReq) {
        String uid = RequestLocalBean.getUid();
        String name = RequestLocalBean.getName();
        Map<String, Object> content = new HashMap<>(10);
        content.put("createUserName", uid);
        content.put("createUser", uid);
        content.put("createTime", System.currentTimeMillis());
        content.put("updateTime", System.currentTimeMillis());
        content.put(CommonConstants.FLOW_OPERATION_KEY, FlowOperationTypeEnum.PASS.getValue());
        String flowName = "";
        // 组装工单创建数据
        FlowCreateReqDTO flowCreateReqDTO = buildFlowCreateReqDTO(ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), uid,
                JSON.toJSONString(content), FlowxOperationEnum.CREATE.getName(), name, flowName);
        // 创建工单
        String subFlowId = flowService.createFlow(flowCreateReqDTO);

        ChangeExecRecord execRecord = new ChangeExecRecord();
        changeSubFlowService.createSubFlow(execRecord);
        return "";
    }

    private FlowCreateReqDTO buildFlowCreateReqDTO(String topoId, String uid, String content, String operateResult,
                                                   String name, String flowName) {
        FlowCreateReqDTO flowCreateReqDTO = new FlowCreateReqDTO();
        flowCreateReqDTO.setTopoId(topoId);
        flowCreateReqDTO.setUid(uid);
        flowCreateReqDTO.setUserName(name);
        flowCreateReqDTO.setOperateResult(operateResult);
        flowCreateReqDTO.setWorkOrderId(StringUtils.joinWith("-", topoId, UUID.randomUUID().toString()));
        flowCreateReqDTO.setContent(content);
        flowCreateReqDTO.setFlowName(flowName);
        return flowCreateReqDTO;
    }

    public List<ChangeExecRecord> list(Integer page, Integer pageSize) {
        return changeSubFlowService.query((page - 1) * pageSize, pageSize);
    }

    /**
     * 子流程提交
     * @param changeSubFlowSubmitReq 子流程提交请求
     * @return 下一节点ID
     */
    public String submitSubFlow(ChangeSubFlowSubmitReq changeSubFlowSubmitReq) {
        log.info("[submitSubFlow] changeSubFlowSubmitReq:{}", JSON.toJSONString(changeSubFlowSubmitReq));
        String subFlowId = changeSubFlowSubmitReq.getSubFlowId();
        
        // 通过子流程工单ID查询行动项记录
        ChangeExecRecord execRecord = changeFlowExecService.getBySubFlowId(subFlowId);
        Assert.notNull(execRecord, "行动项记录不存在");
        
        // 检查工单节点
        String currentNode = execRecord.getSubFlowNode();
        this.checkNode(currentNode, Collections.singletonList(changeSubFlowSubmitReq.getCurrentNodeId()));
        
        String uid = RequestLocalBean.getUid();
        // 验证执行人权限
        if (!uid.equals(execRecord.getChangeExecUserEmail())) {
            throw ExceptionFactory.createBiz(ResponseCode.NO_AUTH, ResponseCode.NO_AUTH.getMsg());
        }
        
        // 获取工单详情
        FlowDataDTO flowDataDTO = flowService.flowDetail(subFlowId);
        if (flowDataDTO == null) {
            throw ExceptionFactory.createBiz(ResponseCode.DETAIL_FLOW_ERROR, "子流程工单查询错误，不存在");
        }
        
        return checkUpdateAndSubmit(subFlowId, flowDataDTO, uid, execRecord, currentNode, changeSubFlowSubmitReq);
    }

    /**
     * 检查并提交子流程节点
     */
    private String checkUpdateAndSubmit(String subFlowId, FlowDataDTO flowDataDTO, String uid, 
                                       ChangeExecRecord execRecord, String currentNode, 
                                       ChangeSubFlowSubmitReq changeSubFlowSubmitReq) {
        ChangeFlowEnum node = ChangeFlowEnum.getByNodeId(currentNode);
        Assert.notNull(node, "节点配置不存在");
        log.debug("[checkUpdateAndSubmit] subFlowId:{}, nodeEnum:{}, changeSubFlowSubmitReq:{}", 
                subFlowId, node, JSON.toJSONString(changeSubFlowSubmitReq));
        
        // 构建工单内容
        Map<String, Object> content = new HashMap<>(CommonConstants.INIT_HASH_MAP_SIZE);
        content.put("updateTime", System.currentTimeMillis());
        content.put(CommonConstants.FLOW_OPERATION_KEY, FlowOperationTypeEnum.PASS.getValue());
        
        switch (node) {
            case CHANGE_SUB_FLOW_START:
                // 确认行动方案节点，直接提交到下一节点
                String nextNodeId = flowService.submitFlow(subFlowId, flowDataDTO, uid,
                        ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), JSON.toJSONString(content), true,
                        FlowxOperationEnum.SUBMIT.getName(), "提交工单", execRecord.getCreateTime());
                // 更新节点ID
                execRecord.setSubFlowNode(nextNodeId);
                execRecord.setUpdateTime(DateUtils.getCurrentTime());
                changeFlowExecService.update(execRecord);
                return nextNodeId;
                
            case CHANGE_SUB_FLOW_SUBMIT:
                // 审批行动方案节点，直接提交到执行节点
                String execNodeId = flowService.submitFlow(subFlowId, flowDataDTO, uid,
                        ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), JSON.toJSONString(content), true,
                        FlowxOperationEnum.SUBMIT.getName(), "提交工单", execRecord.getCreateTime());
                // 更新节点ID
                execRecord.setSubFlowNode(execNodeId);
                execRecord.setUpdateTime(DateUtils.getCurrentTime());
                changeFlowExecService.update(execRecord);
                return execNodeId;
                
            case CHANGE_SUB_FLOW_EXE:
                // 执行行动方案节点，直接提交到提交执行结果节点
                String confirmNodeId = flowService.submitFlow(subFlowId, flowDataDTO, uid,
                        ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), JSON.toJSONString(content), true,
                        FlowxOperationEnum.SUBMIT.getName(), "提交工单", execRecord.getCreateTime());
                // 更新节点ID
                execRecord.setSubFlowNode(confirmNodeId);
                execRecord.setUpdateTime(DateUtils.getCurrentTime());
                changeFlowExecService.update(execRecord);
                return confirmNodeId;
                
            case CHANGE_SUB_FLOW_CONFIRM:
                // 提交执行结果节点，需要填写完成时间和完成情况
                Long finishTime = changeSubFlowSubmitReq.getChangeExecFinishTime();
                String finishDesc = changeSubFlowSubmitReq.getChangeExecFinishDesc();
                Assert.notNull(finishTime, "行动完成时间不可为空");
                Assert.isTrue(StringUtils.isNotBlank(finishDesc), "行动完成情况不可为空");
                
                // 更新完成信息
                execRecord.setChangeExecFinishTime(finishTime);
                execRecord.setChangeExecFinishDesc(finishDesc);
                
                // 提交到结束节点
                String endNodeId = flowService.submitFlow(subFlowId, flowDataDTO, uid,
                        ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), JSON.toJSONString(content), true,
                        FlowxOperationEnum.SUBMIT.getName(), "提交工单", execRecord.getCreateTime());
                // 更新节点ID
                execRecord.setSubFlowNode(endNodeId);
                execRecord.setUpdateTime(DateUtils.getCurrentTime());
                changeFlowExecService.update(execRecord);
                
                // TODO: 子流程完成后，检查主流程是否可以进入确认节点
                log.info("[CHANGE_SUB_FLOW_CONFIRM] 子流程完成，subFlowId:{}, changeExecId:{}", subFlowId, execRecord.getId());
                
                return endNodeId;
                
            default:
                throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "不支持的子流程节点类型");
        }
    }

    /**
     * 检查节点是否匹配
     */
    private void checkNode(String currentNode, List<String> expectedNodes) {
        if (!expectedNodes.contains(currentNode)) {
            throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, 
                    String.format("当前节点[%s]与预期节点[%s]不匹配", currentNode, expectedNodes));
        }
    }
}
