/**
 * @(#)ChangeSubFlowRecordService.java, 2024/01/01.
 * <p/>
 * Copyright 2024 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service;

import java.util.List;

import com.netease.mail.yanxuan.change.dal.entity.ChangeSubFlowRecord;

/**
 * 变更行动工单服务
 * @Author system
 * @Date 2024/01/01
 */
public interface ChangeSubFlowRecordService {

    /**
     * 保存变更行动工单记录
     * @param subFlowRecord 变更行动工单记录
     */
    void saveRecord(ChangeSubFlowRecord subFlowRecord);

    /**
     * 更新变更行动工单记录
     * @param subFlowRecord 变更行动工单记录
     * @return 是否成功
     */
    Boolean update(ChangeSubFlowRecord subFlowRecord);

    /**
     * 根据主单记录ID查询变更行动工单列表
     * @param changeRecordId 主单记录ID
     * @return 变更行动工单列表
     */
    List<ChangeSubFlowRecord> getByChangeRecordId(Long changeRecordId);

    /**
     * 根据变更行动工单ID查询变更行动工单记录
     * @param subFlowId 变更行动工单ID（即topo）
     * @return 变更行动工单记录
     */
    ChangeSubFlowRecord getBySubFlowId(String subFlowId);

}

