/**
 * @(#)ChangeSubFlowRecordServiceImpl.java, 2024/01/01.
 * <p/>
 * Copyright 2024 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.netease.mail.yanxuan.change.biz.service.ChangeSubFlowRecordService;
import com.netease.mail.yanxuan.change.dal.entity.ChangeSubFlowRecord;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeSubFlowRecordMapper;

/**
 * @Author system
 * @Date 2024/01/01
 */
@Service
public class ChangeSubFlowRecordServiceImpl implements ChangeSubFlowRecordService {

    @Autowired
    private ChangeSubFlowRecordMapper changeSubFlowRecordMapper;

    @Override
    public void saveRecord(ChangeSubFlowRecord subFlowRecord) {
        changeSubFlowRecordMapper.insertSelective(subFlowRecord);
    }

    @Override
    public Boolean update(ChangeSubFlowRecord subFlowRecord) {
        return changeSubFlowRecordMapper.updateByPrimaryKeySelective(subFlowRecord) > 0;
    }

    @Override
    public List<ChangeSubFlowRecord> getByChangeRecordId(Long changeRecordId) {
        return changeSubFlowRecordMapper.selectByChangeRecordId(changeRecordId);
    }

    @Override
    public ChangeSubFlowRecord getBySubFlowId(String subFlowId) {
        return changeSubFlowRecordMapper.selectBySubFlowId(subFlowId);
    }

}

