/**
 * @(#)ItemCategoryRpcService.java, 2022/11/30.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.integration.item;

import java.util.List;
import java.util.Map;

import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;

import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.yanxuan.missa.client.annotation.MissaClient;

/**
 * @Author zcwang
 * @Date 2022/11/30
 */
@Service
@MissaClient(serviceCode = "ic-basis", path = "/category")
public interface ItemCategoryRpcService {

    /**
     * 批量查询商品分类物理类目链
     * @param query
     * @return
     */
    @PostMapping(value = "/phy/queryChainByIds", consumes = MediaType.APPLICATION_JSON_VALUE)
    AjaxResult<Map<Long, List<SimplePhyCateGoryResultCo>>> queryCategoryChain(CommonIdsParamQuery query);
}