package com.netease.mail.yanxuan.change.integration.email.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.integration.email.service.UasClientService;
import com.netease.mail.yanxuan.change.integration.flow.email.EmailRpcService;
import com.netease.mail.yanxuan.qc.service.client.remote.UasClient;
import com.netease.mail.yanxuan.qc.service.client.utils.http.HttpClientExecutor;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author WangJiaXiang
 * @date 2022/11/28/028$
 */
@Service
public class UasClientServiceImpl implements UasClientService {

    Logger logger = LoggerFactory.getLogger(UasClientServiceImpl.class);

    @Autowired
    private EmailRpcService service;

    @Autowired
    private HttpClientExecutor httpClientExecutor;

    @Override
    public void sendEmail(String subject, String content, Collection<String> toList, Collection<String> ccList, List<File> fileList) {
        if (!CollectionUtils.isEmpty(toList)) {
            Map<String, String> params = new HashMap();
            params.put("subject", subject);
            params.put("content", content);
            params.put("to", StringUtils.join(toList, ","));
            params.put("topic", "qc");
            if (!CollectionUtils.isEmpty(ccList)) {
                params.put("cc", StringUtils.join(ccList, ","));
            }
            logger.info(JSONObject.toJSONString("邮箱接口入参 subject={},content={},toList={},ccList={}"), subject, content, StringUtils.join(toList, ","), params.get("cc"));
            //String res = service.sendEmail(subject,content,StringUtils.join(toList, ","),params.get("cc"));
            String url = "http://127.0.0.1:8550/proxy/test.logistics-uas.service.mailsaas/push/email/qc";
            String res = this.httpClientExecutor.doPost(url, params);
            this.logger.info("[op:sendEmail] res={} ", new Object[]{res});
            JSONObject jsonObject = JSON.parseObject(res);
            if (jsonObject.getInteger("code") != 200) {
                logger.error("send email has ex: {}", res);
            }
        }
    }

}
