package com.netease.mail.yanxuan.change.integration.item.meta;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author jmt
 * @Date 2021/6/7
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class SkuTo {

    //ID
    private Long id;

    //SPU ID
    private Long spuId;

    //sku展示名
    private String displayName;

    //sku图片
    private String picUrl;

    //是否是主sku
    private boolean primarySku;

    //是否是组合装：0-否；1-是
    private int isCombine;

    //是否启用过：0-否；1-是
    private int isUsed;

    //商品原始销售价，不会因单品变价活动而变动
    private BigDecimal retailPrice;

    //仓库id
    private long storeHouseId;

    //商品条码
    private List<String> barCodeList;

    private long operationAttribute;

    //0-关闭；1-开启；2-作废（对应原invalid=1）
    private int status;

    //SKU描述（目前仅定制商品使用）
    private String skuDesc;

    //SKU规格构成对象
    private List<SkuSpecCombineTO> skuSpecCombine;

    //SPU对象，查询参数增加spu时有值
    private SpuTO spu;

    private Map<String, String> propertyMap;

    //子SKU信息
    private List<ChildSkuTO> childSkuList;

    //预售详情
    private PreSellDetailTO preSellDetail;
}
