package com.netease.mail.yanxuan.change.common.enums;

/**
 * @author WangJiaXiang
 * @date 2022/11/16/016$
 */
public enum ChangeLevelEnum {
    IMPORTANT(1,"重要变更"),
    COMMONLY(2,"一般变更");


    private Integer type;

    private String desc;

    ChangeLevelEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getByType(Integer type) {
        for (ChangeLevelEnum value : ChangeLevelEnum.values()) {
            if (value.getType().equals(type)) {
                return value.getDesc();
            }
        }
        return null;
    }
}
