/**
 * @(#)ChangeExecConfig.java, 2022/11/11.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.mapper;

import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeExecConfigPo;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;

import com.netease.mail.yanxuan.change.dal.entity.ChangeExecConfig;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @Author zcwang
 * @Date 2022/11/11
 */
@Mapper
public interface ChangeExecConfigMapper extends tk.mybatis.mapper.common.Mapper<ChangeExecConfig> {

    @Delete("delete from TB_YX_CHANGE_EXEC_CONFIG where id = #{id}")
    int deleteById(@Param("id") Long id);

    @Select("select * from TB_YX_CHANGE_EXEC_CONFIG where change_template_id = #{changeTemplateId}")
    List<ChangeExecConfig> queryChangeExecConfig(@Param("changeTemplateId")Long changeTemplateId);

    @Select("select COUNT(change_template_id) as coreDepartment, change_exec_department " +
            "from TB_YX_CHANGE_EXEC_CONFIG where change_template_id = #{id} " +
            "group by change_exec_department order by coreDepartment DESC LIMIT 1;")
    ChangeExecConfigPo queryChangeDepartment(@Param("id")Long id);
}