/**
 * @(#)ItemcenterRpcService.java, 2023/1/6.
 * <p/>
 * Copyright 2023 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.rpc;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.bean.ResponseCodeEnum;
import com.netease.mail.yanxuan.change.integration.flow.goods.ItemManagerTO;
import com.netease.mail.yanxuan.change.integration.flow.goods.ItemcenterApiRpcService;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2023/1/6
 */
@Component
@Slf4j
public class ItemcenterRpcService {

    @Autowired
    private ItemcenterApiRpcService itemcenterApiRpcService;

    public List<ItemManagerTO> getProduct(List<Long> itemIds) {
        List<ItemManagerTO> itemManagerTOS = new ArrayList<>();
        List<List<Long>> partition = Lists.partition(itemIds, 200);

        for (List<Long> list : partition) {
            String collect = StringUtils.join(list, ",");
            AjaxResponse<List<ItemManagerTO>> response = itemcenterApiRpcService.getProduct("qc", collect);
            if (ResponseCodeEnum.SUCCESS.getCode() == response.getCode()) {
                log.info("[getProduct] response={}", JSON.toJSONString(response));
                if (CollectionUtils.isNotEmpty(response.getData())) {
                    itemManagerTOS.addAll(response.getData());
                }
            } else {
                log.error("[getProduct] get Product detail failed, query={}, errMsg={}", JSON.toJSONString(itemIds),
                        JSON.toJSONString(response));
                throw ExceptionFactory.createBiz(ResponseCode.DETAIL_FLOW_ERROR, "查询工单详情错误");
            }
        }
        return itemManagerTOS;
    }
}