/**
 * @(#)ChangeFlowOwnershipVO.java, 2024/12/04.
 * <p/>
 * Copyright 2024 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 主单归属关系（用于标识当前用户与主单的归属关系）
 * 对应查询条件：creator = 当前用户 OR change_commander = 当前用户 OR approver 包含当前用户
 * 
 * @Author system
 * @Date 2024/12/04
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ChangeFlowOwnershipVO {

    /**
     * 是否是创建人（creator）
     */
    private Boolean isCreator;

    /**
     * 是否是变更负责人（change_commander）
     */
    private Boolean isChangeCommander;

    /**
     * 是否是审批人（approver）
     */
    private Boolean isApprover;
}

