/**
 * @(#)ChangeFlowService.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service;

import java.util.List;

import com.netease.mail.yanxuan.change.biz.config.TitleConfig;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
public interface ChangeFlowService {

    /**
     * 获取提示文案
     * @return
     */
    TitleConfig getTitleConfig();

    /**
     * 保存工单详情
     * @param changeRecord
     * @return
     */
    Boolean saveRecord(ChangeRecord changeRecord);

    /**
     * 根据工单id查询
     * @param flowId
     * @return
     */
    ChangeRecord getByFlowId(Long flowId);

    /**
     * 更新工单信息
     * @param changeRecord
     * @return
     */
    Boolean updateRecord(ChangeRecord changeRecord);

    /**
     * 根据实例id获取工单详情
     * @param id
     * @return
     */
    ChangeRecord getById(Long id);

    /**
     * 根据状态及时间获取数据
     *
     * @param entityId
     * @param sendEmail
     * @param nodeId1
     * @param nodeId2
     * @param tomorrowSpecificTime
     * @return
     */
    List<ChangeRecord> getByStatusAndTime(Long entityId, Integer sendEmail, String nodeId1, String nodeId2, long tomorrowSpecificTime);
}