/**
 * @(#)ChangeFlowExecService.java, 2022/11/21.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service;

import java.util.List;

import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeFlowExecVO;

/**
 * @Author zcwang
 * @Date 2022/11/21
 */
public interface ChangeFlowExecService {

    /**
     * 查询行动项
     * @param changeRecordId
     * @return
     */
    List<ChangeFlowExecVO> getChangeFlowExecRecord(Long changeRecordId);

    /**
     * 查询行动项实体列表
     * @param changeRecordId
     * @return
     */
    List<ChangeExecRecord> getChangeExecRecordList(Long changeRecordId);

    /**
     * 批量保存变更行动执行记录
     * @param changeExecRecordList
     */
    void batchSaveRecord(List<ChangeExecRecord> changeExecRecordList);

    Boolean update(ChangeExecRecord exec);

    Integer deleteByChangeRecordId(Long id);

    void saveRecord(ChangeExecRecord exec);

    /**
     * 查询包含执行人的工单
     * @param changeExecUser
     * @return
     */
    List<Long> queryByExecUser(String changeExecUser);
}