package com.netease.mail.yanxuan.change.biz.meta;


import java.util.LinkedHashMap;

/**
 * @author lwtang
 */
public class AjaxResult extends LinkedHashMap<String, Object> {

    private static final long serialVersionUID = 5451316194035153776L;

    public AjaxResult() {
        setCode(ResponseCode.SUCCESS);
    }

    public AjaxResult(int code, String msg) {
        setCodeInt(code);
        put(MSG, msg);
    }

    public AjaxResult(ResponseCode responseCode) {
        setCode(responseCode);
    }

    public AjaxResult(ResponseCode responseCode, Object result) {
        setCode(responseCode);
        put(RESULT, result);
    }

    /**
     * 响应code，默认<code>ResponseCode.SUCCESS</code>
     */
    public static final String CODE = "code";

    /**
     * 消息
     */
    public static final String MSG = "msg";

    /**
     * 结果
     */
    public static final String RESULT = "data";

    public void setCode(ResponseCode code) {
        put(CODE, code.getCode());
    }

    public void setMsg(String msg) {
        put(MSG, msg);
    }

    public void setCodeInt(int code) {
        put(CODE, code);
    }

    public ResponseCode getCode() {
        return (ResponseCode) get(CODE);
    }

    public Object getResult() {
        return (String) get(RESULT);
    }

    public void setResult(Object result) {
        put(RESULT, result);
    }

    public static AjaxResult with(Object result) {
        return new AjaxResult(ResponseCode.SUCCESS, result);
    }
}
