/**
 * @(#)AppConfig.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.ctrip.framework.apollo.spring.annotation.EnableAutoUpdateApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ValueMapping;
import com.sun.org.apache.xpath.internal.operations.Bool;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
@Component
@EnableAutoUpdateApolloConfig("application")
@Data
public class AppConfig {

    @ValueMapping("${titleConfig:null}")
    private TitleConfig titleConfig;

    @Value("${changeExecLimit:20}")
    private Integer changeExecLimit;

    @Value("${testEmail:A@163.com}")
    private String testEmail;

    @Value("${change.goods.principal.name:aaa}")
    private String defaultName;

    @Value("${change.goods.principal.email:grp.gyhtest1001@corp.netease.com}")
    private String defaultEmail;
}