/*
package com.netease.mail.yanxuan.change.integration.email.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.netease.mail.yanxuan.change.integration.email.conig.ThirdCommonApolloConfig;
import com.netease.mail.yanxuan.change.integration.email.dto.UserInfoDTO;
import com.netease.mail.yanxuan.change.integration.email.email.*;
import com.netease.mail.yanxuan.change.integration.email.enums.*;
import com.netease.mail.yanxuan.change.integration.email.service.IEmailEhcService;
import com.netease.mail.yanxuan.change.integration.email.service.IIusService;
import com.netease.mail.yanxuan.change.integration.email.service.IUasEhcClient;
import com.netease.mail.yanxuan.change.integration.email.service.ISupplierEmailService;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class EmailEhcServiceImpl implements IEmailEhcService {

    private Logger logger = LoggerFactory.getLogger(EmailEhcServiceImpl.class);

    @Autowired
    private IUasEhcClient uasEhcClient;

    @Autowired
    private EmailTemplateServiceImpl emailTemplateService;

    @Autowired
    private ISupplierEmailService supplierEmailService;

    @Autowired
    private ThirdCommonApolloConfig thirdCommonApolloConfig;

    @Autowired
    private IIusService iusService;

    */
/**
     * 主工单微应用地址
     *//*

    private static final String ABNORMAL_FLOW_EMAIL_URL = "/error-center-node#/problem/detail/%s";

    */
/**
     * 临时措施微应用地址
     *//*

    private static final String TASK_FLOW_EMAIL_URL = "/error-center-node#/sonwork/measures/%s?newFlow=true";

    private static final String TASK_FLOW_EMAIL_URL_SUPPLIER = "&pageFrom=todo";

    */
/**
     * 惩罚供应商微应用地址
     *//*

    private static final String PUNISH_FLOW_EMAIL_URL = "/error-center-node#/sonwork/punish/%s?newFlow=true";

    */
/**
     * 批量事件工单微应用地址
     *//*

    private static final String EVENT_FLOW_EMAIL_URL = "/error-center-node#/sonwork/batch/%s";

    @Override
    @Async
    public void sendTaskEmail(Collection<String> toList, Collection<String> ccList, AbnormalTaskFlowEhcEmailModel model,
        EmailEhcFlowEnum emailEhcFlowEnum) {
        String subject = emailEhcFlowEnum.getSubject();
        subject = String.format(subject, model.getTaskTypeName(), model.getAbnormalName(), model.getTaskFlowId());
        //邮件url
        for (String str: toList) {
            try {
                List<String> uidLists = new ArrayList<>();
                model.setUrl(getTaskFlowEmailUrl(str, model.getExecUserType()));
                model.setUrl(model.getUrl() + String.format(TASK_FLOW_EMAIL_URL, model.getTaskFlowId()));
                logger.debug("[sendTaskEmail] url:{}", JSON.toJSONString(model.getUrl()));
                uidLists.add(str);
                EmailEhcFactor factor = EmailEhcFactor.builder()
                    .data(JSONObject.parseObject(JSON.toJSONString(model), Map.class))
                    .emailEhcFlowEnum(emailEhcFlowEnum).subject(subject).type(EmailTypeEnum.TEXT.getType()).build();
                logger.debug("[sendTaskEmail] flowId:{}, factor:{}", model.getTaskFlowId(), JSON.toJSONString(factor));
                this.sendEmail(uidLists, ccList, factor, null);
            } catch (Exception e) {
                logger.error("[sendTaskEmail] flowId:{}, str={}, e={}", model.getTaskFlowId(), str, e);
            }

        }
    }

    @Override
    public void sendSupplierEmail(String supplierId, AbnormalTaskFlowEhcEmailModel model,
        EmailEhcFlowEnum emailEhcFlowEnum) {
        SupplierEmailSendReq req = new SupplierEmailSendReq();
        req.setSupplierId(supplierId);
        req.setMailSubject(String.format(emailEhcFlowEnum.getSubject(), model.getTaskTypeName(),
            model.getAbnormalName(), model.getTaskFlowId()));
        model.setUrl(getTaskFlowEmailUrl(null, model.getExecUserType()));
        model.setUrl(
            model.getUrl() + String.format(TASK_FLOW_EMAIL_URL, model.getTaskFlowId()) + TASK_FLOW_EMAIL_URL_SUPPLIER);
        EmailEhcFactor factor = EmailEhcFactor.builder()
            .data(JSONObject.parseObject(JSON.toJSONString(model), Map.class)).emailEhcFlowEnum(emailEhcFlowEnum)
            .subject(req.getMailSubject()).type(EmailTypeEnum.TEXT.getType()).build();
        req.setMailContent(content(factor));
        logger.debug("[sendSupplierEmail] 发送供应商邮件内容 flowId:{}, req:{}", model.getTaskFlowId(), JSON.toJSONString(req));
        supplierEmailService.sendSupplierEmail(req);
    }

    @Override
    @Async
    public void sendPunishEmail(Collection<String> toList, Collection<String> ccList,
                                AbnormalPunishFlowEhcEmailModel model, EmailEhcFlowEnum emailEhcFlowEnum) {
        String subject = emailEhcFlowEnum.getSubject();
        subject = String.format(subject, model.getAbnormalName(), model.getTaskFlowId());
        //邮件url
        for (String str: toList) {
            try {
                List<String> uidLists = new ArrayList<>();
                model.setUrl(getEmailContentUrl(str));
                model.setUrl(model.getUrl() + String.format(PUNISH_FLOW_EMAIL_URL, model.getTaskFlowId()));
                uidLists.add(str);
                EmailEhcFactor factor = EmailEhcFactor.builder()
                    .data(JSONObject.parseObject(JSON.toJSONString(model), Map.class))
                    .emailEhcFlowEnum(emailEhcFlowEnum).subject(subject).type(EmailTypeEnum.TEXT.getType()).build();
                logger.debug("[sendPunishEmail]flowId:{}, factor:{}", model.getTaskFlowId(), JSON.toJSONString(factor));
                this.sendEmail(uidLists, ccList, factor, null);
            } catch (Exception e) {
                logger.error("[sendPunishEmail] str={}, e={}", str, e);
            }

        }
    }

    @Override
    @Async
    public void sendBathEventEmail(Collection<String> toList, Collection<String> ccList,
                                   AbnormalBathEventEhcEmailModel model, EmailEhcFlowEnum emailEhcFlowEnum) {
        String subject = emailEhcFlowEnum.getSubject();
        logger.debug("[sendBathEventEmail] before subject:{}", subject);
        subject = String.format(subject, model.getAbnormalName(), model.getTaskFlowId());
        logger.debug("[sendBathEventEmail] after subject:{}", subject);
        //邮件url
        for (String str: toList) {
            List<String> uidLists = new ArrayList<>();
            model.setUrl(getEmailContentUrl(str));
            model.setUrl(model.getUrl() + String.format(EVENT_FLOW_EMAIL_URL, model.getTaskFlowId()));
            logger.debug("[sendBathEventEmail] url:{}", JSON.toJSONString(model.getUrl()));
            uidLists.add(str);
            EmailEhcFactor factor = EmailEhcFactor.builder()
                .data(JSONObject.parseObject(JSON.toJSONString(model), Map.class)).emailEhcFlowEnum(emailEhcFlowEnum)
                .subject(subject).type(EmailTypeEnum.TEXT.getType()).build();
            logger.debug("[sendBathEventEmail] flowId:{}, factor:{}", model.getTaskFlowId(), JSON.toJSONString(factor));
            this.sendEmail(uidLists, ccList, factor, null);
        }

    }

    @Override
    public void sendOverTimeEmail(Collection<String> toList, Collection<String> ccList, FlowEhcOverTimeEmailModel model,
        EmailEhcFlowEnum emailEhcFlowEnum) {
        logger.info("[sendOverTimeEmail] toList={}, ccList={}", JSON.toJSONString(toList), JSON.toJSONString(ccList));
        String subject = emailEhcFlowEnum.getSubject();
        //邮件url
        for (String str: toList) {
            List<String> uidLists = new ArrayList<>();
            if (!CollectionUtils.isEmpty(model.getAbnormalEhcEmailModels())) {
                model.getAbnormalEhcEmailModels().stream().forEach(f -> {
                    f.setFlowUrl(getEmailContentUrl(str));
                    f.setFlowUrl(f.getFlowUrl() + String.format(ABNORMAL_FLOW_EMAIL_URL, f.getFlowId()));
                    logger.debug("[sendOverTimeEmail] url:{}", JSON.toJSONString(f.getFlowUrl()));
                });
            }
            if (!CollectionUtils.isEmpty(model.getTaskEhcFlowOverTimeEmailModels())) {
                model.getTaskEhcFlowOverTimeEmailModels().stream().forEach(f -> {
                    f.setUrl(getEmailContentUrl(str));
                    if (f.getTaskFlowType().equals(AllTaskFlowTypeEnum.SUPPLIER_PUNISHMENT.getName())) {
                        f.setUrl(f.getUrl() + String.format(PUNISH_FLOW_EMAIL_URL, f.getTaskFlowId()));
                    } else if (f.getTaskFlowType().equals(AllTaskFlowTypeEnum.BATCH_EVENT.getName())) {
                        f.setUrl(f.getUrl() + String.format(EVENT_FLOW_EMAIL_URL, f.getTaskFlowId()));
                    } else {
                        f.setUrl(f.getUrl() + String.format(TASK_FLOW_EMAIL_URL, f.getTaskFlowId()));
                    }
                    logger.debug("[sendOverTimeEmail] url:{}", JSON.toJSONString(f.getUrl()));
                });
            }
            uidLists.add(str);
            EmailEhcFactor factor = EmailEhcFactor.builder()
                .data(JSONObject.parseObject(JSON.toJSONString(model), Map.class)).emailEhcFlowEnum(emailEhcFlowEnum)
                .subject(subject).type(EmailTypeEnum.TEXT.getType()).build();
            this.sendEmail(uidLists, ccList, factor, null);
        }
    }

    @Override
    @Async
    public void sendAbnormalEmail(Collection<String> toList, Collection<String> ccList,
                                  EmailEhcFlowEnum emailEhcFlowEnum, AbnormalEhcEmailModel abnormalEhcEmailModel) {
        String subject = String.format(emailEhcFlowEnum.getSubject(), abnormalEhcEmailModel.getAbnormalName(),
            abnormalEhcEmailModel.getFlowId());
        // 收件人
        for (String uid: toList) {
            String prefixUrl = getEmailContentUrl(uid);
            String flowUrl = prefixUrl + String.format(ABNORMAL_FLOW_EMAIL_URL, abnormalEhcEmailModel.getFlowId());
            abnormalEhcEmailModel.setFlowUrl(flowUrl);
            EmailEhcFactor factor = EmailEhcFactor.builder()
                .data(JSONObject.parseObject(JSON.toJSONString(abnormalEhcEmailModel), Map.class))
                .emailEhcFlowEnum(emailEhcFlowEnum).subject(subject).type(EmailTypeEnum.TEXT.getType()).build();
            factor.setSubject(subject);
            this.sendEmail(Lists.newArrayList(uid), ccList, factor, null);
            logger.debug("[sendAbnormalEmail] flowId={}, toList={}, ccList={}, factor={}",
                abnormalEhcEmailModel.getFlowId(), uid, null, JSON.toJSONString(factor));
            ccList = null;
        }
    }

    @Override
    @Async
    public void sendEmail(Collection<String> toList, Collection<String> ccList, EmailEhcFactor factor,
        List<File> fileList) {
        logger.info("[sendEmail] toList:{}, ccList:{}, factor:{}", JSON.toJSONString(toList),
            JSON.toJSONString(ccList), JSON.toJSONString(factor));
        if (factor != null) {
            String content = content(factor);
            String subject = factor.getSubject();
            if (!CollectionUtils.isEmpty(toList)) {
                toList = toList.stream().filter(StringUtils::hasText).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(ccList)) {
                ccList = ccList.stream().filter(StringUtils::hasText).collect(Collectors.toList());
            }
            //发送邮件
            uasEhcClient.sendEmail(subject, content, toList, ccList, fileList);
        }
    }

    */
/**
     * 根据邮件模版获取邮件内容
     *
     * @param emailFactor
     * @return
     *//*

    private String content(EmailEhcFactor emailFactor) {
        EmailEhcFlowEnum emailEhcFlowEnum = emailFactor.getEmailEhcFlowEnum();
        return emailTemplateService.template(emailEhcFlowEnum.getCode(), emailFactor.getData(), emailFactor.getType());
    }

    */
/**
     * 根据apollo配置获取邮件通知主应用url（如果没有，则默认返回第一个主应用url）
     *
     * @param uid
     * @return
     *//*

    @Override
    public String getEmailContentUrl(final String uid) {
        List<JumpLinkModel> emailUrlList = thirdCommonApolloConfig.getEmailFlowUrl();
        for (JumpLinkModel vo: emailUrlList) {
            List<UserInfoDTO> userList = iusService.queryUserInfo(vo.getProductCode(), uid);
            if (!CollectionUtils.isEmpty(userList)
                && !StaffStatusEnum.DIMISSION.getType().equals(userList.get(0).getStaffStatus())) {
                // 解锁且是非离职状态
                logger.info("[getEmailContentUrl] uid={}, vo={}", uid, JSON.toJSONString(vo));
                return vo.getUrl();
            }
        }
        return thirdCommonApolloConfig.getEmailFlowUrl().get(0).getUrl();
    }

    @Override
    public String getTaskFlowEmailUrl(String uid, Integer execUserType) {
        logger.info("[getTaskFlowEmailUrl] uid:{}, execUserType:{}", uid, execUserType);
        List<String> urlList = new ArrayList<>();
        if (ExecUserTypeEnum.YANXUAN_MEMBER.getValue().equals(execUserType)) {
            // 严选人员
            return getEmailContentUrl(uid);
        } else if (ExecUserTypeEnum.LOGISTICS_SERVICE_PROVIDER.getValue().equals(execUserType)) {
            // 物流服务商
            urlList.addAll(thirdCommonApolloConfig.getEmailFlowUrl().stream()
                .filter(f -> f.getProductCode().equals(ProductCodeEnum.CARRIER.getCode())).map(JumpLinkModel::getUrl)
                .collect(Collectors.toList()));
        } else if (ExecUserTypeEnum.WAREHOUSE_SERVICE_PROVIDER.getValue().equals(execUserType)) {
            // 系统仓
            urlList.addAll(thirdCommonApolloConfig.getEmailFlowUrl().stream()
                .filter(f -> f.getProductCode().equals(ProductCodeEnum.HORNET.getCode())).map(JumpLinkModel::getUrl)
                .collect(Collectors.toList()));
        } else if (ExecUserTypeEnum.SUPPLIER.getValue().equals(execUserType)) {
            // 供应商
            urlList.addAll(thirdCommonApolloConfig.getEmailFlowUrl().stream()
                .filter(f -> f.getProductCode().equals(ProductCodeEnum.SUPPLIER_API.getCode()))
                .map(JumpLinkModel::getUrl).collect(Collectors.toList()));
        }
        logger.debug("[getTaskFlowEmailUrl] urlList={}", JSON.toJSONString(urlList));
        if (CollectionUtils.isEmpty(urlList)) {
            // 如果没有，则默认返回第一个主应用url
            urlList.add(thirdCommonApolloConfig.getEmailFlowUrl().get(0).getUrl());
        }
        return urlList.get(0);
    }

}
*/
