/**
 * @(#)ChangeFlowRequest.java, 2022/12/8.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.req;

import com.netease.mail.yanxuan.change.common.enums.CreateSourceEnum;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/12/8
 */
@Data
public class ChangeFlowRequest {
    /**
     * 变更商品（变更主体为商品时有效）
     */
    private String itemId;

    /**
     * 变更供应商（变更主体为供应商时有效）
     */
    private String supplier;

    /**
     * 一级变更类型id
     */
    private Long parentChangeClassId;

    /**
     * 二级变更类型id
     */
    private Long sonChangeClassId;

    /**
     * 工单状态
     */
    private Integer changeState;

    /**
     * 变更负责人
     */
    private String changeCommander;

    /**
     * 变更负责部门名
     */
    private String changeDepartment;

    /**
     * 变更行动部门
     */
    private String changeExecDepartment;

    /**
     * 开始时间
     */
    private Long startTime;

    /**
     * 结束时间
     */
    private Long endTime;

    /**
     * 创建端
     * @see CreateSourceEnum
     */
    private Integer createSource;

    /**
     * 创建供应商（同舟端创建）
     */
    private String createSupplier;

    private String serviceCode;

    private String uid;

    /**
     * 工单id
     */
    private Long flowId;
}