/**
 * @(#)BusinessFormEnum.java, 2022/12/20.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.common.enums;

/**
 * @Author zcwang
 * @Date 2022/12/20
 */
public enum BusinessFormEnum {
    SELF_SUPPORT(0,"自营"),
    YX_SELECTION_OEM(3,"严选贴牌代销"),
    OTHER_BRANDS(4,"他方品牌代销"),
    COMMISSION2(5,"代销2.0");

    private Integer type;

    private String desc;

    BusinessFormEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getByType(Integer type) {
        for (BusinessFormEnum value : BusinessFormEnum.values()) {
            if (value.getType().equals(type)) {
                return value.getDesc();
            }
        }
        return "";
    }
}