package com.netease.mail.yanxuan.change.integration.flow.supplier;

import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierGoodsInfoReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierSearchRemoteReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierSendEmailReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierGoodsInfoRsp;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierSimpleRsp;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import com.netease.yanxuan.missa.client.annotation.MissaClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import java.util.List;

/**
 * @author WangJiaXiang
 * @date 2022/11/24/024$
 */
@Service
@MissaClient(serviceCode = "yanxuan-supplier-ms")
public interface FlowRpcSupplierSendService {

    /**
     * 邮件通知接口
     * @param req
     * @return
     */
    @PostMapping("/api/supplier/msg/sendMail.json")
    String sendEmail(@RequestBody SupplierSendEmailReq req);

    /**
     * 获取商品采购人信息
     * @param itemIds
     * @return
     */
    @PostMapping("/api/initiateProject/source/getBatchRelatedSupplier.json")
    String queryGoodsPurchase(@RequestBody List<Long> itemIds);


    /**
     * 供应商模糊查询
     */
    @PostMapping("/api/supplier/queryByConditionForQc.json")
    AjaxResult<List<SupplierSimpleRsp>> queryByConditionForQc(@RequestBody SupplierSearchRemoteReq req);

    /**
     * 跟进供应商ID 互殴去供应商的商品
     * @return
     */
    @PostMapping("/api/initiateProject/quote/listSupplierQuoteInfoBySupplierIds.json")
    AjaxResponse<List<SupplierGoodsInfoRsp>> supplierGoodsInfoBySupplier(@RequestBody SupplierGoodsInfoReq req);
}
