package com.netease.mail.yanxuan.change.web.controller;


import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.biz.service.InteriorChangeConfigService;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.biz.service.change.AdminChangeConfigService;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeCommanderPO;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigReq;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsResponseRpc;
import com.netease.mail.yanxuan.change.integration.flow.ius.*;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@RequestMapping("/config/change")
@RestController
public class ChangeConfigController {

    @Autowired
    private AdminChangeConfigService service;

    /**
     * 通过参数查询配置模板
     * @return
     */
    @GetMapping("/list")
    public AjaxResult queryChanges(
            @RequestParam(name = "page",defaultValue = "1") Integer page,
            @RequestParam(name = "pageSize",defaultValue = "10")Integer pageSize,
            @RequestParam(name = "changeDepartment",required = false) String changeDepartment,
            @RequestParam(name = "changeExecDepartment",required = false) String changeExecDepartment,
            @RequestParam(name = "parentChangeClassId",required = false)Integer parentChangeClassId,
            @RequestParam(name = "sonChangeClassId",required = false)Integer sonChangeClassId,
            @RequestParam(name = "changeLevel",required = false)Integer changeLevel,
            @RequestParam(name = "startTime",required = false)Long startTime,
            @RequestParam(name = "endTime",required = false)Long endTime){
        ChangeConfigQueryReq req = new ChangeConfigQueryReq();
        req.setChangeDepartment(changeDepartment);
        req.setChangeExecDepartment(changeExecDepartment);
        req.setParentChangeClassId(parentChangeClassId);
        req.setSonChangeClassId(sonChangeClassId);
        req.setChangeLevel(changeLevel);
        req.setCreateTime(startTime);
        req.setUpdateTime(endTime);
        return service.queryChanges(page,pageSize,req);
    }

    /**
     * 查询变更模板详情
     * @param id
     * @param sonChangeClassId
     * @return
     */
    @GetMapping("/detail")
    public AjaxResult queryDetail(
            @RequestParam(name = "id") Long id,
            @RequestParam(name = "sonChangeClassId") Long sonChangeClassId){
        return service.queryDetail(id, sonChangeClassId);
    }

    /**
     * 新增变更模板详情
     * @param changeConfigReq
     * @return
     */
    @PostMapping("/create")
    public AjaxResult createChange(
            @RequestBody ChangeConfigReq changeConfigReq){
        return service.createChange(changeConfigReq);
    }

    /**
     * 修改变更模板详情
     * @param changeConfigReq
     * @return
     */
    @PostMapping("/modify")
    public AjaxResult modifyChange(
            @RequestBody ChangeConfigReq changeConfigReq){
        return service.modifyChange(changeConfigReq);
    }

    /**
     * 删除模板配置
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public AjaxResult deleteChange(
            @RequestBody Long id){
        return service.deleteChange(id);
    }

    /**
     * 查询所有模板配置类型
     * @return
     */
    @GetMapping("/query/config/type")
    public AjaxResult queryConfigType(){
        return service.queryConfigType();
    }

    @Autowired
    private FlowIusRpcService iusRpcService;

    @GetMapping("/test")
    public AjaxResponse<IusUserInfoRsp> queryGoods(){
        return iusRpcService.queryUserInfo("grp.gyhtest1001@corp.netease.com");
    }

    private static Logger logger = LoggerFactory.getLogger(ChangeConfigController.class);

    @GetMapping("/test1")
    public AjaxResponse<HashMap<String, List<SecondaryDepartments>>> queryGoods1(){
        ArrayList<String> strings = new ArrayList<>();
        strings.add("grp.gyhtest1001@corp.netease.com");
        return iusRpcService.queryDepartment(new IusDepartmentReq(strings));
    }

    @GetMapping("/test2")
    public  AjaxResponse<List<OrgPosLeaderChainRsp>>  queryGoods2(){
        AjaxResponse<List<OrgPosLeaderChainRsp>>  objectAjaxResponse = iusRpcService.queryLeaderChain("grp.gyhtest1001@corp.netease.com");
        return objectAjaxResponse;
    }


    @Autowired
    private InteriorChangeConfigService changeConfigService;

    @PostMapping("/test3")
    public GoodsResponseRpc queryCommanderInfo(@RequestBody ChangeCommanderPO changeCommander){
        return changeConfigService.queryCommanderInfo(changeCommander);
    }

}
