/**
 * @(#)buildAndSendEmail.java, 2023/2/7.
 * <p/>
 * Copyright 2023 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service;

import java.util.List;

import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowCreateReq;

/**
 * @Author zcwang
 * @Date 2023/2/7
 */
public interface BuildAndSendEmail {

    /**
     * 创建工单，创建人=变更负责人，组装提交数据，并发送邮件
     * @param changeRecord
     * @param changeExecRecords
     * @param changeType
     * @param changeCommander
     * @param changeFlowCreateReq
     */
    void buildAndSendEmailCreate(ChangeRecord changeRecord, List<ChangeExecRecord> changeExecRecords, StringBuilder changeType, String changeCommander, ChangeFlowCreateReq changeFlowCreateReq);

    /**
     * 提交工单，变更确认节点，组装提交数据，并发送邮件
     * @param changeRecord
     * @param changeExecRecords
     */
    void buildAndSendEmailSubmit(ChangeRecord changeRecord, List<ChangeExecRecord> changeExecRecords);

    /**
     * 发送确认变更结果完成邮件通知
     * 接收人：变更行动人、变更行动人上一级主管、变更供应商、变更管理QA群组
     * todo: 待业务确认邮件模板和内容参数
     * 
     * @param changeRecord 变更记录
     */
    void sendConfirmResultFinishEmail(ChangeRecord changeRecord);

    /**
     * 发送确认变更结果取消邮件通知
     * 接收人：变更行动人、变更行动人上一级主管、变更供应商、变更管理QA群组
     * todo: 待业务确认邮件模板和内容参数
     * 
     * @param changeRecord 变更记录
     * @param cancelReason 取消原因
     */
    void sendConfirmResultCancelEmail(ChangeRecord changeRecord, String cancelReason);
}