/**
 * @(#)ItemSetupTypeEnum.java, 2022/12/20.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.common.enums;

/**
 * @Author zcwang
 * @Date 2022/12/20
 */
public enum ItemSetupTypeEnum {
    normal(0, "正常立项商品"),
    special(2, "特殊免立项商品"),
    combination(3, "组合装");

    private Integer type;
    private String desc;

    ItemSetupTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getByType(Integer type) {
        for (ItemSetupTypeEnum value : ItemSetupTypeEnum.values()) {
            if (value.getType().equals(type)) {
                return value.getDesc();
            }
        }
        return "";
    }
}