package com.netease.mail.yanxuan.change.biz.util;

import com.netease.mail.yanxuan.change.dal.meta.model.vo.PageVO;

/**
 * 分页工具类
 * @Author system
 * @Date 2024/01/01
 */
public class PageUtils {

    /**
     * 构建分页信息
     * 根据总记录数、每页大小和当前页码构建分页VO
     *
     * @param total 总记录数
     * @param pageSize 每页大小
     * @param page 当前页码
     * @return 分页信息
     */
    public static PageVO buildPageVo(Long total, Integer pageSize, Integer page) {
        Integer totalCount = Math.toIntExact(total);
        int totalPage;
        int i = totalCount % pageSize;
        if (i != 0) {
            totalPage = totalCount / pageSize + 1;
        } else {
            totalPage = totalCount / pageSize;
        }
        return PageVO.builder().page(page).totalPage(totalPage).pageSize(pageSize).pageCount(pageSize)
                .totalCount(totalCount).build();
    }
}

