/**
 * @(#)AppConfig.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.ctrip.framework.apollo.spring.annotation.EnableAutoUpdateApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ValueMapping;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
@Component
@EnableAutoUpdateApolloConfig("application")
@Data
public class AppConfig {

    @ValueMapping("${titleConfig:null}")
    private TitleConfig titleConfig;

    @Value("${changeExecLimit:20}")
    private Integer changeExecLimit;

    /**
     * 商品关联开发兜底人名
     */
    @Value("${change.goods.functionary.name:\"钱伟钰\"}")
    private String functionaryName;

    /**
     * 商品关联开发兜底邮箱
     */
    @Value("${change.goods.functionary.email:\"qianweiyu@corp.netease.com\"}")
    private String functionaryEmail;

    /**
     * 商品关联采购兜底人名
     */
    @Value("${change.goods.purchase.name:\"陈金灿\"}")
    private String purchaseName;

    /**
     * 商品关联采购兜底邮箱
     */
    @Value("${change.goods.purchase.email:\"bjchenjincan@corp.netease.com\"}")
    private String purchaseEmail;
    /**
     * 商品关联计划兜底人名
     */
    @Value("${change.goods.project.name:\"王敏\"}")
    private String goodsProjectName;

    /**
     * 商品关联计划兜底邮箱
     */
    @Value("${change.goods.project.email:\"wangmin12@corp.netease.com\"}")
    private String goodsProjectEmail;

    /**
     * 商品关联SQE兜底邮箱
     */
    @Value("${change.goods.sqe.name:\"崔亦仙\"}")
    private String sqeName;

    /**
     * 商品关联SQE兜底邮箱
     */
    @Value("${change.goods.sqe.email:\"cuiyixian@corp.netease.com\"}")
    private String sqeEmail;

    /**
     * 变更管理QM
     */
    @Value("${changeManageQM:cuiyixian@corp.netease.com}")
    private String changeManageQM;

    /**
     * 变更管理委员会
     */
    @Value("${changeCommittee:yx_change_SC@qun.mail.163.com}")
    private String changeCommittee;

    @Value("${exportLimit:20}")
    private Long exportLimit;
}