package com.netease.mail.yanxuan.change.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.InteriorChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.enums.ChangeCommanderEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangePrincipalEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeCommanderPO;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeGoodsPrincipalPO;
import com.netease.mail.yanxuan.change.dal.meta.model.po.QueryCommanderEmailReq;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.CommanderResponse;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsPurchaseRpc;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsResponseRpc;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsResponseSqeRpc;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ItemVO;
import com.netease.mail.yanxuan.change.integration.flow.goods.ItemcenterApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.goods.PfuApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.goods.QcApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierInfoService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierRelatedUserReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierUserRsp;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author WangJiaXiang
 * @date 2022/11/18/018$
 */
@Slf4j
@Service
public class InteriorChangeConfigServiceImpl implements InteriorChangeConfigService {

    private static final Logger logger = LoggerFactory.getLogger(InteriorChangeConfigServiceImpl.class);

    @Autowired
    private ChangeConfigService changeConfigService;

    //查询商品的SQE
    @Autowired
    private QcApiRpcService qcApiRpcService;
    //查看执行人
    @Autowired
    private PfuApiRpcService pfuApiRpcService;
    //查看商品BU
    @Autowired
    private ItemcenterApiRpcService itemcenterApiRpcService;
    @Autowired
    private FlowRpcSupplierSendService supplierSendService;

    @Autowired
    private AppConfig appConfig;

    /**
     * 项目上线后接口需要修改未线上环境
     */
    @Autowired
    private FlowRpcSupplierInfoService supplierInfoService;

    /**
     * 接口不完整,关于商品的查询已经完成  供应商查询不完整接口已对接 具体返回值接口测试未完成
     *
     * @param changeCommander
     * @return
     */
    @Override
    public GoodsResponseRpc queryCommanderInfo(ChangeCommanderPO changeCommander) {
        GoodsResponseRpc rpc = new GoodsResponseRpc();
        //获取模板名称   通过一级变更类型 二级变更类型ID 定位模板
        ChangeConfig changeConfig = changeConfigService.queryChangeType(changeCommander.getParentChangeClassId(), changeCommander.getSonChangeClassId());
        if (changeConfig == null) {
            return null;
        }
        //查询出当前模板配置中选择的 角色
        ChangeCommanderEnum changeCommanderEnum = ChangeCommanderEnum.getChangeCommanderEnum(changeConfig.getChangeCommanderType());
        if (changeCommanderEnum == null) {
            return null;
        }
        //直接排除 选项为固定人 或者发起人
        if (Objects.equals(changeConfig.getChangeCommanderType(), ChangeCommanderEnum.COMMANDER_ORIGINATOR.getId())) {
            //发起人;
            rpc.setEmail(changeCommander.getFlowCreator());
            return rpc;
        }
        if (Objects.equals(changeConfig.getChangeCommanderType(), ChangeCommanderEnum.FIXED_PERSON.getId())) {
            //固定人;
            rpc.setEmail(changeConfig.getChangeCommander());
            return rpc;
        }
        if (Objects.equals(ChangeSubjectEnum.PRODUCT.getType(), changeConfig.getChangeSubject())) {
            //商品变更
            return queryGoodsCommander(changeCommanderEnum, changeCommander.getGoodsInfos(), changeConfig.getChangeCommander());
        } else if (Objects.equals(ChangeSubjectEnum.SUPPLIER.getType(), changeConfig.getChangeSubject())) {
            //供应商  采购 计划 SQE
            return queryChangeSupplier(changeCommanderEnum, changeCommander.getChangeSupplierId(), changeConfig.getChangeCommander());
        }
        //其他变更 备注 其他变更之后固定人 和发起人在上面判断会被排除掉     changeConfig.getChangeCommander();
        return null;
    }

    /**
     * 商品的最终角色查询
     *
     * @param commanderEnum 查询方向 枚举
     * @param goodsInfos    商品的列表
     * @param commander     商品的关联角色  ChangeCommanderEnum
     * @return
     */
    private GoodsResponseRpc queryGoodsCommander(ChangeCommanderEnum commanderEnum, List<Long> goodsInfos, String commander) {
        if (!commanderEnum.getId().equals(ChangeCommanderEnum.GOODS_ASSOCIATED.getId())
                || CollectionUtils.isEmpty(goodsInfos) || commander == null) {
            return null;
        }
        Map<String, GoodsResponseRpc> map = new HashMap<String, GoodsResponseRpc>();
        //记录最大出现次数
        int temp = 0;
        //记录最大值
        GoodsResponseRpc name = new GoodsResponseRpc();
        //记录出现的所有值
        List<GoodsResponseRpc> emails = new ArrayList<GoodsResponseRpc>();
        //遍历取出所有商品关联的人

        if (ChangePrincipalEnum.GOODS_BU.getName().equals(commander)) {
            String detail = itemcenterApiRpcService.getDetail(goodsInfos);
            logger.error("根据商品查看商品负责BU接口返回值\t" + detail);
            getGoodsNameEmail(emails, detail);

        } else if (ChangePrincipalEnum.PURCHASE.getName().equals(commander)) {
            //采购返回值处理逻辑
            String detail = supplierSendService.queryGoodsPurchase(goodsInfos);
            logger.error("根据商品查看商品负责采购接口返回值\t" + detail);
            JSONObject jsonObject = JSONObject.parseObject(detail);
            List<GoodsPurchaseRpc> purchaseRpcs = JSONObject.parseArray(jsonObject.get("data").toString(), GoodsPurchaseRpc.class);
            for (GoodsPurchaseRpc purchaseRpc : purchaseRpcs) {
                GoodsResponseRpc goodsRpc = new GoodsResponseRpc();
                goodsRpc.setEmail(purchaseRpc.getSupplierTraceBusiness());
                goodsRpc.setName(purchaseRpc.getSupplierName());
                emails.add(goodsRpc);
            }
        } else if (ChangePrincipalEnum.PROSPECTUS.getName().equals(commander)) {
            String detail = pfuApiRpcService.getDetail(goodsInfos);
            logger.error("根据商品查看商品负责计划接口返回值\t" + detail);
            getGoodsNameEmail(emails, detail);
        } else if (ChangePrincipalEnum.SQE.getName().equals(commander)) {
            for (Long goods : goodsInfos) {
                String detail = qcApiRpcService.getDetail(goods.intValue());
                logger.error("根据商品查看商品负责SQE接口返回值\t" + detail);
                JSONObject jsonObject = JSONObject.parseObject(detail);
                GoodsResponseSqeRpc data = jsonObject.getObject("data", GoodsResponseSqeRpc.class);
                if (data != null) {
                    //需要验证返回值 是否正确
                    GoodsResponseRpc rpc = new GoodsResponseRpc();
                    rpc.setEmail(data.getUserName());
                    rpc.setName(data.getRealName());
                    emails.add(rpc);
                }
            }
        }
        //逻辑发生变更
        for (GoodsResponseRpc email : emails) {
            if (!map.containsKey(email.getName())) {
                email.setOccurrenceNumber(1);
            } else {
                GoodsResponseRpc goodsResponseRpc = map.get(email.getName());
                email.setOccurrenceNumber(goodsResponseRpc.getOccurrenceNumber() + 1);
                if (temp < goodsResponseRpc.getOccurrenceNumber()) {
                    temp = goodsResponseRpc.getOccurrenceNumber();
                    name = goodsResponseRpc;
                }
            }
            map.put(email.getName(), email);
        }
        if (name.getName() == null) {
            Iterator<GoodsResponseRpc> iterator = map.values().iterator();
            name = iterator.next();
        }
        return name;
    }


    /**
     * 供应商角色最终查询
     *
     * @param commanderEnum    查询方向 枚举
     * @param changeSupplierId 供应商信息
     * @param commander        供应商关联角色
     * @return
     */
    private GoodsResponseRpc queryChangeSupplier(ChangeCommanderEnum commanderEnum, String changeSupplierId, String commander) {
        GoodsResponseRpc rpc = new GoodsResponseRpc();
        if (!commanderEnum.getId().equals(ChangeCommanderEnum.SUPPLIERS_ASSOCIATED.getId()) || changeSupplierId == null || commander == null) {
            return null;
        }
        SupplierRelatedUserReq req = new SupplierRelatedUserReq();
        List<String> supplierIdList = new ArrayList<>();
        supplierIdList.add(changeSupplierId);
        //changeSupplier 根据提供的信息去查询 最终返回
        if (ChangePrincipalEnum.PURCHASE.getName().equals(commander)) {
            req.setSearchType(1);
        } else if (ChangePrincipalEnum.PROSPECTUS.getName().equals(commander)) {
            req.setSearchType(2);
        } else if (ChangePrincipalEnum.SQE.getName().equals(commander)) {
            req.setSearchType(3);
        }
        req.setSupplierIdList(supplierIdList);
        //进行参数解析
        List<SupplierUserRsp> listAjaxResponse = supplierInfoService.querySupplierRelatedUser(req);
        if (CollectionUtils.isEmpty(listAjaxResponse)) {
            return null;
        }
        SupplierUserRsp supplierUserRsp = listAjaxResponse.get(0);
        Map<String, String> uid2NameMap = supplierUserRsp.getUid2NameMap();
        for (String key : uid2NameMap.keySet()) {
            rpc.setName(key);
            rpc.setEmail(uid2NameMap.get(key));
        }
        return rpc;
    }


    /**
     * 重复代码复用方法
     *
     * @param emails   储存邮箱队列
     * @param response 请求返结果
     */
    private void getGoodsNameEmail(List<GoodsResponseRpc> emails, String response) {
        JSONObject jsonObject = JSONObject.parseObject(response);
        Map<String, JSONObject> rpcMap = JSONObject.parseObject(jsonObject.get("data").toString(), Map.class);
        if (rpcMap == null) {
            throw ExceptionFactory.createBiz(ResponseCode.OPERATOR_NOT_EXIST);
        }
        for (String rpc : rpcMap.keySet()) {
            GoodsResponseRpc goodsRpc = new GoodsResponseRpc();
            goodsRpc.setEmail(rpcMap.get(rpc).get("uid").toString());
            goodsRpc.setName(rpcMap.get(rpc).get("name").toString());
            emails.add(goodsRpc);
        }
    }

    @Override
    public Map<Long, ChangeGoodsPrincipalPO> queryGoodsPrincipalInfo(List<Long> itemIds) {
        Map<Long, ChangeGoodsPrincipalPO> map = new HashMap<>();
        for (Long itemId : itemIds) {
            map.put(itemId, new ChangeGoodsPrincipalPO());
        }
        //商品BU
        String functionary = itemcenterApiRpcService.getDetail(itemIds);
        logger.error("请求商品BU结果" + functionary);
        getGoodsPrincipalNameEmail(ChangePrincipalEnum.GOODS_BU.getType(), map, functionary);
        //计划
        String project = pfuApiRpcService.getDetail(itemIds);
        logger.error("请求商品计划结果" + project);
        getGoodsPrincipalNameEmail(ChangePrincipalEnum.PURCHASE.getType(), map, project);
        //商品采购
        String GoodsPurchase = supplierSendService.queryGoodsPurchase(itemIds);
        JSONObject jsonObject = JSONObject.parseObject(GoodsPurchase);
        List<GoodsPurchaseRpc> purchaseRpcs = JSONObject.parseArray(jsonObject.get("data").toString(), GoodsPurchaseRpc.class);
        for (GoodsPurchaseRpc rpc : purchaseRpcs) {
            map.get(rpc.getItemId().longValue()).setPurchaseName(rpc.getSupplierName());
            map.get(rpc.getItemId().longValue()).setPurchaseEmail(rpc.getSupplierTraceBusiness());
            goodsRpc(ChangePrincipalEnum.PURCHASE.getType(), rpc.getSupplierName(), map.get(rpc.getItemId().longValue()));
        }
        //SQE
        for (Long itemId : itemIds) {
            String sqe = qcApiRpcService.getDetail(itemId.intValue());
            logger.error("根据商品查看商品负责SQE接口返回值\t" + sqe);
            JSONObject jsonObject1 = JSONObject.parseObject(sqe);
            GoodsResponseSqeRpc data = jsonObject1.getObject("data", GoodsResponseSqeRpc.class);
            if (data != null) {
                //需要验证返回值 是否正确
                map.get(itemId).setGoodsSqeName(data.getRealName());
                map.get(itemId).setGoodsSqeEmail(data.getUserName());
                goodsRpc(ChangePrincipalEnum.SQE.getType(), data.getRealName(), map.get(itemId));
            }
        }
        return map;
    }

    @Override
    public CommanderResponse queryCommanderEmail(QueryCommanderEmailReq req) {
        Integer changeExecUserType = req.getChangeExecUserType();
        String changeExecUser = req.getChangeExecUser();
        ChangeCommanderEnum changeCommanderEnum = ChangeCommanderEnum.getChangeCommanderEnum(changeExecUserType);
        log.debug("[queryCommanderEmail] req:{},changeCommanderEnum:{}", JSON.toJSONString(req), changeCommanderEnum);
        Assert.notNull(changeCommanderEnum, "变更负责人类型错误");
        CommanderResponse commanderResponse = new CommanderResponse();
        switch (changeCommanderEnum) {
            case COMMANDER_ORIGINATOR:
            case FIXED_PERSON:
                return null;
            case GOODS_ASSOCIATED:
                String changeItems = req.getChangeItems();
                Assert.isTrue(StringUtils.isNotBlank(changeItems), "变更负责人为商品时，商品列表不可为空");
                List<ItemVO> itemVOS = JSON.parseArray(changeItems, ItemVO.class);
                List<Long> itemIdList = itemVOS.stream().map(ItemVO::getItemId).collect(Collectors.toList());

                try {
                    GoodsResponseRpc goodsResponseRpc = queryGoodsCommander(changeCommanderEnum, itemIdList, changeExecUser);
                    log.debug("[queryCommanderEmail] queryGoodsCommander:{}", JSON.toJSONString(goodsResponseRpc));
                    commanderResponse.setName(goodsResponseRpc.getName());
                    commanderResponse.setEmail(goodsResponseRpc.getEmail());
                } catch (Exception e) {
                    log.error("[queryGoodsCommander] error,e{}", e);
                    commanderResponse.setEmail(appConfig.getDefaultEmail());
                }
                return commanderResponse;
            case SUPPLIERS_ASSOCIATED:
                String changeSupplier = req.getChangeSupplier();
                Assert.isTrue(StringUtils.isNotBlank(changeSupplier), "变更负责人为供应商时，供应商不可为空");
                try {
                    GoodsResponseRpc supplierResponseRpc = queryChangeSupplier(changeCommanderEnum,
                            changeSupplier, changeExecUser);
                    log.debug("[queryCommanderEmail] queryChangeSupplier:{}", JSON.toJSONString(supplierResponseRpc));
                    commanderResponse.setName(supplierResponseRpc.getName());
                    commanderResponse.setEmail(supplierResponseRpc.getEmail());
                } catch (Exception e) {
                    log.error("[queryChangeSupplier] error,e{}", e);
                    commanderResponse.setEmail(appConfig.getDefaultEmail());
                }
                return commanderResponse;
            default:
                throw ExceptionFactory.createBiz(ResponseCode.COMMANDER_TYPE_NOT_EXIST, "变更负责人类型错误");
        }
    }

    /**
     * 请求数据解析以及装载
     *
     * @param type     1:BU  2:计划
     * @param map
     * @param response
     */
    private void getGoodsPrincipalNameEmail(Integer type, Map<Long, ChangeGoodsPrincipalPO> map, String response) {
        JSONObject jsonObject = JSONObject.parseObject(response);
        Map<String, JSONObject> rpcMap = JSONObject.parseObject(jsonObject.get("data").toString(), Map.class);
        if (rpcMap == null) {
            throw ExceptionFactory.createBiz(ResponseCode.OPERATOR_NOT_EXIST);
        }
        for (String rpc : rpcMap.keySet()) {
            ChangeGoodsPrincipalPO goodsRpc = map.get(Long.parseLong(rpc));
            if (type.equals(ChangePrincipalEnum.GOODS_BU.getType())) {
                goodsRpc.setFunctionaryName(rpcMap.get(rpc).get("name").toString());
                goodsRpc.setFunctionaryEmail(rpcMap.get(rpc).get("uid").toString());
                goodsRpc(ChangePrincipalEnum.GOODS_BU.getType(), rpcMap.get(rpc).get("uid").toString(), goodsRpc);
            } else {
                goodsRpc.setGoodsProjectName(rpcMap.get(rpc).get("name").toString());
                goodsRpc.setGoodsProjectEmail(rpcMap.get(rpc).get("uid").toString());
                goodsRpc(ChangePrincipalEnum.PROSPECTUS.getType(), rpcMap.get(rpc).get("uid").toString(), goodsRpc);
            }
        }
    }


    /**
     * 负责人兜底方法
     *
     * @param type
     * @param uid
     * @param goodsRpc
     */
    private void goodsRpc(Integer type, String uid, ChangeGoodsPrincipalPO goodsRpc) {
        // todo:mock数据
        String defaultName = appConfig.getDefaultName();
        String defaultEmail = appConfig.getDefaultEmail();
        if (uid == null) {
            switch (type) {
                case 1:
                    //BU
                    goodsRpc.setFunctionaryName(defaultName);
                    goodsRpc.setFunctionaryEmail(defaultEmail);
                case 2:
                    //采购
                    goodsRpc.setPurchaseName(defaultName);
                    goodsRpc.setPurchaseEmail(defaultEmail);
                case 3:
                    //计划
                    goodsRpc.setGoodsProjectName(defaultName);
                    goodsRpc.setGoodsProjectName(defaultEmail);
                case 4:
                    //SQE
                    goodsRpc.setGoodsSqeName(defaultName);
                    goodsRpc.setGoodsSqeEmail(defaultEmail);
            }

        }
    }

}
