/**
 * @(#)ChangeFlowDeliverReq.java, 2022/11/25.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.req;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/25
 */
@Data
public class ChangeFlowDeliverReq {

    /**
     * 工单id
     */
    @NotNull(message = "工单id不能为空")
    private Long flowId;

    /**
     * 变更负责人
     */
    @NotBlank(message = "转交人不可为空")
    private String deliverUser;

    /**
     * 转交备注
     */
    @NotBlank(message = "转交备注不可为空")
    private String remark;
}