package com.netease.mail.yanxuan.change.integration.email.dto;

import java.util.List;

public class UserUniteOrgMetaDTO extends UserOrgMetaDTO {

    private static final long serialVersionUID = -1682465589038072525L;

    /**
     * 关联类型 type NORMAL(0, "普通职员"), DERECT(1, "指导员"), MANAGER(2, "负责人");
     */
    private int type;

    /**
     * 员工职责
     */
    private String duty;

    /**
     * 员工状态
     */
    private int staffStatus;

    /**
     * 员工工号
     */
    private String employeeNum;

    /**
     * 员工在职信息类型，OAWorkInfoEnum（0-不在OA，1-在严选事业部，2-在外部门）
     */
    private int workInfoType;

    /**
     * 在职状态，EmployeeStateEnum（0-试用，1-正式，5-离职）
     */
    private int workState;

    /**
     * 0-未收藏，1-已收藏
     */
    private int focusStatus;

    /**
     * 所在的其他职位列表，不包含当前职位
     */
    private List<OrgPosDTO> multiOrgPoss;

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDuty() {
        return duty;
    }

    public void setDuty(String duty) {
        this.duty = duty;
    }

    public int getStaffStatus() {
        return staffStatus;
    }

    public void setStaffStatus(int staffStatus) {
        this.staffStatus = staffStatus;
    }

    public String getEmployeeNum() {
        return employeeNum;
    }

    public void setEmployeeNum(String employeeNum) {
        this.employeeNum = employeeNum;
    }

    public int getWorkInfoType() {
        return workInfoType;
    }

    public void setWorkInfoType(int workInfoType) {
        this.workInfoType = workInfoType;
    }

    public int getWorkState() {
        return workState;
    }

    public void setWorkState(int workState) {
        this.workState = workState;
    }

    public int getFocusStatus() {
        return focusStatus;
    }

    public void setFocusStatus(int focusStatus) {
        this.focusStatus = focusStatus;
    }

    public List<OrgPosDTO> getMultiOrgPoss() {
        return multiOrgPoss;
    }

    public void setMultiOrgPoss(List<OrgPosDTO> multiOrgPoss) {
        this.multiOrgPoss = multiOrgPoss;
    }
}
