package com.netease.mail.yanxuan.change.biz.service.impl.change;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.change.AdminChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeExecConfigService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeTypeService;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.common.bean.RequestLocalBean;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.bean.ResponseCodeEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecConfig;
import com.netease.mail.yanxuan.change.dal.entity.ChangeType;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeConfigMapper;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeConfigPo;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigDeleteReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigReq;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeConfigArrayVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeConfigVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.PageVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@Service
public class AdminChangeConfigServiceImpl implements AdminChangeConfigService {

    private static final String CHANGE_CONFIG = "changeConfig:";
    @Autowired
    public ChangeConfigMapper mapper;
    Logger logger = LoggerFactory.getLogger(AdminChangeConfigServiceImpl.class);
    @Autowired
    private ChangeTypeService typeService;
    @Autowired
    private ChangeConfigService changeConfigService;
    @Autowired
    private ChangeExecConfigService execConfigService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    private ValueOperations<String, String> value;

    @Override
    public AjaxResult queryChanges(Integer pageNum, Integer pageSize, ChangeConfigQueryReq req) {
        ChangeConfigArrayVO vo = new ChangeConfigArrayVO();
        //进行分页
        PageHelper.startPage(pageNum, pageSize);
        List<ChangeConfigPo> changeConfigPos = mapper.selectChangeConfigPo(req);
        PageInfo<ChangeConfigPo> pageInfo = new PageInfo<>(changeConfigPos);
        Long total = pageInfo.getTotal();
        PageVO pageVO = buildPageVo(total.intValue(), pageSize, pageNum);
        List<ChangeConfigPo> changeConfig = pageInfo.getList();
        changeConfig.forEach(i -> {
            String replaceDep = i.getParticipateChangeExecDepartment().replace("[", "").replace("]", "");
            Set<String> finialDep = Arrays.stream(replaceDep.split(",")).collect(Collectors.toSet());
            i.setParticipateChangeExecDepartment(Joiner.on(",").join(finialDep));
        });
        vo.setChangeConfigs(changeConfig);
        vo.setPageVo(pageVO);
        return AjaxResult.success(vo);
    }

    @Override
    public AjaxResult queryDetail(Long id, Long sonChangeClassId) {
        String changeConfigVO;
        //尝试从reids里面 获取 如果获取到了直接返回
        if (id != null) {
            changeConfigVO = getValue().get(id.toString());
            if (changeConfigVO != null) {
                return AjaxResult.success(JSONObject.parseObject(changeConfigVO, ChangeConfigVO.class));
            }
        }
        //从数据库中取出数据
        ChangeConfig changeConfig = changeConfigService.queryChangeConfig(id, sonChangeClassId);
        if (changeConfig == null) {
            return AjaxResult.of(ResponseCodeEnum.NO_FOUND);
        }
        List<ChangeType> changeTypes = typeService.queryChangeType(changeConfig.getParentChangeClassId(), changeConfig.getSonChangeClassId(), true);
        if (changeTypes == null || changeTypes.size() != 2) {
            return AjaxResult.of(ResponseCodeEnum.NO_FOUND);
        }
        List<ChangeExecConfig> changeExecConfigs = execConfigService.queryChangeExecConfig(changeConfig.getId());
        if (changeExecConfigs == null || changeExecConfigs.size() == 0) {
            return AjaxResult.of(ResponseCodeEnum.NO_FOUND);
        }
        //组装数据
        changeConfigVO = getChangeConfigVO(changeConfig, changeTypes, changeExecConfigs);
        //如果没有查询后返回redis
        getValue().set(CHANGE_CONFIG + id, changeConfigVO, 1, TimeUnit.DAYS);
        return AjaxResult.success(JSON.parseObject(changeConfigVO, ChangeConfigVO.class));
    }

    @Override
    @Transactional
    public AjaxResult createChange(ChangeConfigReq changeConfigReq) {
        logger.info("查看入参值" + changeConfigReq.toString());
        //添加一级二级类目
        List<ChangeType> changeTypes = typeService.addChangeType(changeConfigReq.getChangeTypes());
        ChangeConfig changeConfig = parameterSplicing(changeTypes, changeConfigReq);
        changeConfig = changeConfigService.addChangeConfig(changeConfig);
        List<ChangeExecConfig> changeExecConfigs = execConfigService.addChangeExecConfig(changeConfig.getId(), changeConfigReq.getChangeExeConfig());
        //参数拼装
        String changeConfigVO = getChangeConfigVO(changeConfig, changeTypes, changeExecConfigs);
        //新增后添加到redis
        getValue().set(CHANGE_CONFIG + changeConfig.getId(), changeConfigVO, 1, TimeUnit.DAYS);
        return AjaxResult.success();
    }

    @Override
    @Transactional
    public AjaxResult modifyChange(ChangeConfigReq changeConfigReq) {
        if (changeConfigReq.getId() == null) {
            return AjaxResult.of(9001, "修改变更模板主键id不能为空");
        }
        //先查询注入ID后在修改
        ChangeConfig config = changeConfigService.queryChangeConfig(changeConfigReq.getId());
        if (config == null) {
            return AjaxResult.of(9001, "未找到变更类型配置");
        }
        changeConfigReq.getChangeTypes().get(0).setId(config.getParentChangeClassId());
        changeConfigReq.getChangeTypes().get(1).setId(config.getSonChangeClassId());
        //新增类似
        List<ChangeType> changeTypes = typeService.updateChangeType(changeConfigReq.getChangeTypes());
        ChangeConfig changeConfig = parameterSplicing(changeTypes, changeConfigReq);
        changeConfigService.updateChangeConfig(changeConfig);
        //修改
        List<ChangeExecConfig> changeExecConfigs = execConfigService.updateChangeExecConfig(changeConfigReq.getId(), changeConfigReq.getChangeExeConfig());
        //装在reids
        String changeConfigVO = getChangeConfigVO(changeConfig, changeTypes, changeExecConfigs);
        getValue().set(CHANGE_CONFIG + changeConfig.getId(), changeConfigVO, 1, TimeUnit.DAYS);
        //修改后更新redis
        return AjaxResult.success();
    }

    @Override
    @Transactional
    public AjaxResult deleteChange(ChangeConfigDeleteReq id) {
        if (id == null && id.getId() == null) {
            return AjaxResult.of(ResponseCodeEnum.PARAM_ERROR);
        }
        ChangeConfig changeConfig = changeConfigService.queryChangeConfig(id.getId());
        if (changeConfig == null) {
            return AjaxResult.of(ResponseCodeEnum.NO_FOUND);
        }
        changeConfigService.deleteChangeConfig(id.getId());
        List<ChangeType> changeTypes = typeService.queryChangeType(changeConfig.getParentChangeClassId(), changeConfig.getSonChangeClassId(), true);
        typeService.deleteChangeTypes(changeTypes);
        execConfigService.deleteChangeConfig(id.getId());
        // 缓存内删除
        redisTemplate.delete(CHANGE_CONFIG + id.getId());
        return AjaxResult.success();
    }

    /**
     * 二级目录类型查询出所有一级二级
     *
     * @return
     */
    @Override
    public AjaxResult queryConfigType() {
        return AjaxResult.success(typeService.queryConfigType());
    }

    /**
     * 添加变更模板并参数拼接
     *
     * @param changeTypes
     * @param changeConfigReq
     * @return
     */
    private ChangeConfig parameterSplicing(List<ChangeType> changeTypes, ChangeConfigReq changeConfigReq) {
        ChangeConfig changeConfig = new ChangeConfig();
        changeConfig.setParentChangeClassId(changeTypes.get(0).getId());
        changeConfig.setSonChangeClassId(changeTypes.get(1).getId());
        if (changeConfigReq.getId() != null) {
            changeConfig.setId(changeConfigReq.getId());
        }
        if (changeConfigReq.getChangeSubject() == null) {
            throw ExceptionFactory.createBiz(ResponseCode.PARAMETER_DEFICIENCY);
        }
        //验证变更主体
        ChangeSubjectEnum containsChangeSubject = ChangeSubjectEnum.getByType(changeConfigReq.getChangeSubject());
        if (containsChangeSubject == null) {
            throw ExceptionFactory.createBiz(ResponseCode.CANT_FOUND, "变更主体不存在");
        }
        changeConfig.setChangeSubject(changeConfigReq.getChangeSubject());
        if (changeConfigReq.getChangeLevel() == null) {
            throw ExceptionFactory.createBiz(ResponseCode.PARAMETER_DEFICIENCY);
        }
        changeConfig.setChangeLevel(changeConfigReq.getChangeLevel());
        if (changeConfigReq.getChangeDepartment() == null) {
            throw ExceptionFactory.createBiz(ResponseCode.PARAMETER_DEFICIENCY);
        }
        changeConfig.setChangeDepartment(changeConfigReq.getChangeDepartment());
        if (changeConfigReq.getChangeCommanderType() == null) {
            throw ExceptionFactory.createBiz(ResponseCode.PARAMETER_DEFICIENCY);
            //如果是执行人就从head里面把邮箱装载
        } else if (changeConfigReq.getChangeCommanderType() == 1) {
            changeConfigReq.setChangeCommander(RequestLocalBean.getUid());
        }
        changeConfig.setChangeCommanderType(changeConfigReq.getChangeCommanderType());
        if (changeConfigReq.getChangeCommander() == null) {
            throw ExceptionFactory.createBiz(ResponseCode.PARAMETER_DEFICIENCY);
        }
        changeConfig.setChangeCommander(changeConfigReq.getChangeCommander());
        if (changeConfigReq.getNeedFile() == null) {
            throw ExceptionFactory.createBiz(ResponseCode.PARAMETER_DEFICIENCY);
        }
        changeConfig.setNeedFile(changeConfigReq.getNeedFile());
        changeConfig.setCreateTime(System.currentTimeMillis());
        changeConfig.setUpdateTime(System.currentTimeMillis());
        if (changeConfigReq.getChangeExeConfig() == null || changeConfigReq.getChangeExeConfig().size() >= 21) {
            throw ExceptionFactory.createBiz(ResponseCode.EXEC_CONFIG_LENGTH);
        }
        List<String> list = new ArrayList<>();
        for (ChangeExecConfig execConfig : changeConfigReq.getChangeExeConfig()) {
            list.add(execConfig.getChangeExecDepartment());
        }
        changeConfig.setParticipateChangeExecDepartment(list.toString());
        return changeConfig;
    }


    private ValueOperations<String, String> getValue() {
        if (value == null) {
            value = redisTemplate.opsForValue();
        }
        return value;
    }

    private String getChangeConfigVO(ChangeConfig changeConfig, List<ChangeType> changeTypes, List<ChangeExecConfig> changeExecConfigs) {
        ChangeConfigVO vo = new ChangeConfigVO();
        vo.setChangeConfig(changeConfig);
        vo.setChangeTypes(changeTypes);
        vo.setChangeExecConfigs(changeExecConfigs);
        return JSONObject.toJSONString(vo);
    }

    private PageVO buildPageVo(int totalCount, Integer pageSize, Integer page) {
        int totalPage;
        int i = totalCount % pageSize;
        if (i != 0) {
            totalPage = totalCount / pageSize + 1;
        } else {
            totalPage = totalCount / pageSize;
        }
        return PageVO.builder().page(page).totalPage(totalPage).pageSize(pageSize).pageCount(pageSize)
                .totalCount(totalCount).build();
    }

}
