package com.netease.mail.yanxuan.change.web.controller;


import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.biz.service.change.AdminChangeConfigService;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigReq;
import com.netease.mail.yanxuan.change.integration.email.email.EmailFactor;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTemplateEnum;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTypeEnum;
import com.netease.mail.yanxuan.change.integration.email.service.IEmailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@RequestMapping("/config/change")
@RestController
public class ChangeConfigController {

    @Autowired
    private AdminChangeConfigService service;

    /**
     * 通过参数查询配置模板
     * @return
     */
    @GetMapping("/list")
    public AjaxResult queryChanges(
            @RequestParam(name = "page",defaultValue = "1") Integer page,
            @RequestParam(name = "pageSize",defaultValue = "10")Integer pageSize,
            @RequestParam(name = "changeDepartment",required = false) String changeDepartment,
            @RequestParam(name = "changeExecDepartment",required = false) String changeExecDepartment,
            @RequestParam(name = "parentChangeClassId",required = false)Integer parentChangeClassId,
            @RequestParam(name = "sonChangeClassId",required = false)Integer sonChangeClassId,
            @RequestParam(name = "changeLevel",required = false)Integer changeLevel,
            @RequestParam(name = "startTime",required = false)Long startTime,
            @RequestParam(name = "endTime",required = false)Long endTime){
        ChangeConfigQueryReq req = new ChangeConfigQueryReq();
        req.setChangeDepartment(changeDepartment);
        req.setChangeExecDepartment(changeExecDepartment);
        req.setParentChangeClassId(parentChangeClassId);
        req.setSonChangeClassId(sonChangeClassId);
        req.setChangeLevel(changeLevel);
        req.setCreateTime(startTime);
        req.setUpdateTime(endTime);
        return service.queryChanges(page,pageSize,req);
    }

    /**
     * 查询变更模板详情
     * @param id
     * @return
     */
    @GetMapping("/detail")
    public AjaxResult queryDetail(
            @RequestParam(name = "id") Long id){
        return service.queryDetail(id);
    }

    /**
     * 新增变更模板详情
     * @param changeConfigReq
     * @return
     */
    @PostMapping("/create")
    public AjaxResult createChange(
            @RequestBody ChangeConfigReq changeConfigReq){
        return service.createChange(changeConfigReq);
    }

    /**
     * 修改变更模板详情
     * @param changeConfigReq
     * @return
     */
    @PostMapping("/modify")
    public AjaxResult modifyChange(
            @RequestBody ChangeConfigReq changeConfigReq){
        return service.modifyChange(changeConfigReq);
    }

    /**
     * 删除模板配置
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public AjaxResult deleteChange(
            @RequestBody Long id){
        return service.deleteChange(id);
    }

    /**
     * 查询所有模板配置类型
     * @return
     */
    @GetMapping("/query/config/type")
    public AjaxResult queryConfigType(){
        return service.queryConfigType();
    }

    private static Logger logger = LoggerFactory.getLogger(ChangeConfigController.class);

    @Autowired
    private IEmailService iEmailService;

    @GetMapping("/test")
    public void queryCommanderInfo(){
        EmailFactor emailFactor = new EmailFactor();
        emailFactor.setType(EmailTypeEnum.TEXT.getType());
        emailFactor.setEmailTemplateEnum(EmailTemplateEnum.YX_QC_CHANGE_SUBMIT_FORWARD);
        List<String> list = new ArrayList<>();
        list.add("99888");
        ArrayList<String> strings = new ArrayList<>();
        strings.add("wb.tanglongwei@mesg.corp.netease.com");
        HashMap<String,Object> map = new HashMap<>();
        map.put("changeId","变更Id");
        map.put("changeSubject","变更主体");
        map.put("changeContent","变更内容");
        map.put("changeCommander","负责人名称");
        map.put("changeCommanderEmail","负责人邮箱");
        map.put("restsChangeCommander","转交后责任人名称");
        map.put("restsChangeCommanderEmail","转交后责任人邮箱");
        emailFactor.setData(map);
        iEmailService.sendEmail(strings,null,emailFactor,list);

    }

}
