package com.netease.mail.yanxuan.change.integration.flow.supplier.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierInfoService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierRelatedUserReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.ItemSupplierRsp;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierUserRsp;
import com.netease.mail.yanxuan.change.integration.rpc.RpcListData;
import com.netease.mail.yanxuan.change.integration.rpc.RpcTemplate;
import com.netease.mail.yanxuan.change.integration.supplier.SupplierRpcService;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;

/**
 * @author WangJiaXiang
 * @date 2022/12/8/008$
 */
@Service
public class FlowRpcSupplierInfoServiceImpl implements FlowRpcSupplierInfoService {

    private final String path = "/api/supplier/batchGetSupplierRelatedUser.json";

    @Autowired
    private RpcTemplate rpcTemplate;

    @Autowired
    private SupplierRpcService supplierRpcService;

    @Value("${supplier.url}")
    private String supplierUrl;

    Logger logger = LoggerFactory.getLogger(FlowRpcSupplierInfoServiceImpl.class);

    @Override
    public List<SupplierUserRsp> querySupplierRelatedUser(SupplierRelatedUserReq req) {
        List<SupplierUserRsp> objects = null;
        try {
            String url = supplierUrl + path;
            objects = rpcTemplate.postJson(url, JSON.toJSONString(req), 500,
                new RpcListData<>(SupplierUserRsp.class));
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("请求返回结果,e:{}", e);
        }
        return objects;
    }

    @Override
    public List<ItemSupplierRsp> querySupplierByItemIds(List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return new ArrayList<>();
        }
        
        try {
            // 调用底层SupplierRpcService查询供应商信息
            AjaxResponse<List<ItemSupplierRsp>> response = supplierRpcService.querySupplierByItemIds(itemIds);
            logger.info("[querySupplierByItemIds] querySupplierByItemIds response: {}", JSON.toJSONString(response));
            
            if (response == null || CollectionUtils.isEmpty(response.getData())) {
                return new ArrayList<>();
            }
            
            return response.getData();
            
        } catch (Exception e) {
            logger.error("[querySupplierByItemIds] query supplier failed, itemIds={}", JSON.toJSONString(itemIds), e);
            return new ArrayList<>();
        }
    }
}
