/**
 * @(#)ChangeSubFlowListQueryReq.java, 2024/01/01.
 * <p/>
 * Copyright 2024 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.req;

import lombok.Data;

import java.util.List;

/**
 * 变更行动工单列表查询请求
 *
 * @Author system
 * @Date 2024/01/01
 */
@Data
public class ChangeSubFlowListQueryReq {
    /**
     * 变更工单ID（主单flowId）
     */
    private Long flowId;

    /**
     * 变更行动工单ID（subFlowId）
     */
    private String subFlowId;

    /**
     * 商品ID
     */
    private String itemId;

    /**
     * 供应商
     */
    private String supplier;

    /**
     * 变更行动人（姓名或邮箱）
     */
    private String changeExecUser;

    /**
     * 变更行动部门
     */
    private String changeExecDepartment;

    /**
     * 行动工单状态（subFlowNode）
     */
    private String subFlowNode;

    /**
     * 开始时间（行动工单发起时间）
     */
    private Long startTime;

    /**
     * 结束时间（行动工单发起时间）
     */
    private Long endTime;

    /**
     * 数据可见范围：仅查看我跟进的工单（默认true）
     * true: 仅展示当前用户相关的变更行动工单
     * false: 展示所有变更行动工单
     */
    private Boolean onlyMyFollowed;

    /**
     * 当前用户邮箱（用于数据可见范围过滤）
     */
    private String currentUser;

    /**
     * 变更记录ID列表（用于过滤）
     */
    private List<Long> changeRecordIds;

    /**
     * 变更行动工单ID列表（用于过滤）
     */
    private List<String> subFlowIds;
}

