package com.netease.mail.yanxuan.change.integration.email.email;

import com.netease.mail.yanxuan.change.integration.email.enums.EmailTemplateEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class EmailFactor {
    private static final String SUBJECT_PREFIX = "【品控工作台】";

    protected String subject;

    /**
     * 邮件模版
     */
    private EmailTemplateEnum emailTemplateEnum;
    /**
     * 邮件模版组装数据对
     */
    private Map<String, Object> data;
    /**
     * 邮件类型
     */
    private String type;

    public String getSubject() {
        String subject = emailTemplateEnum.getSubject();
        if(StringUtils.isNotBlank(subject)){
            return subject;
        }
        /*if (data != null) {
            Object flowId = data.get(EmailParamEnum.FLOW_ID.getKey());
            Object taskType = data.get(EmailParamEnum.TASK_TYPE.getKey());
            String format = emailTemplateEnum.getSubject();
            if(flowId != null && taskType == null){
                return String.format(format, flowId);
            }else if(flowId != null && taskType != null){
                return String.format(format, taskType, flowId);
            }else {
                return SUBJECT_PREFIX;
            }

        }*/
        return SUBJECT_PREFIX;
    }

}
