package com.netease.mail.yanxuan.change.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.biz.service.change.AdminChangeConfigService;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigReq;
import com.netease.mail.yanxuan.change.integration.flow.ItemcenterApiRpcService;
import com.netease.mail.yanxuan.change.integration.flow.PfuApiRpcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;
import java.util.Map;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@RequestMapping("/config/change")
@RestController
public class ChangeConfigController {

    @Autowired
    private AdminChangeConfigService service;

    /**
     * 通过参数查询配置模板
     * @return
     */
    @GetMapping("/list")
    public AjaxResult queryChanges(
            @RequestParam(name = "pageNum",defaultValue = "1") Integer pageNum,
            @RequestParam(name = "pageSize",defaultValue = "10")Integer pageSize,
            @RequestParam(name = "changeDepartment",required = false) String changeDepartment,
            @RequestParam(name = "changeExecDepartment",required = false) String changeExecDepartment,
            @RequestParam(name = "parentChangeClassId",required = false)Integer parentChangeClassId,
            @RequestParam(name = "sonChangeClassId",required = false)Integer sonChangeClassId,
            @RequestParam(name = "changeLevel",required = false)Integer changeLevel,
            @RequestParam(name = "createTime",required = false)Long createTime,
            @RequestParam(name = "updateTime",required = false)Long updateTime){
        ChangeConfigQueryReq req = new ChangeConfigQueryReq();
        req.setChangeDepartment(changeDepartment);
        req.setChangeExecDepartment(changeExecDepartment);
        req.setParentChangeClassId(parentChangeClassId);
        req.setSonChangeClassId(sonChangeClassId);
        req.setChangeLevel(changeLevel);
        req.setCreateTime(createTime);
        req.setUpdateTime(updateTime);
        return service.queryChanges(pageNum,pageSize,req);
    }

    /**
     * 查询变更模板详情
     * @param id
     * @param sonChangeClassId
     * @return
     */
    @GetMapping("/detail")
    public AjaxResult queryDetail(
            @RequestParam(name = "id") Long id,
            @RequestParam(name = "sonChangeClassId") Long sonChangeClassId){
        return service.queryDetail(id, sonChangeClassId);
    }

    /**
     * 新增变更模板详情
     * @param changeConfigReq
     * @return
     */
    @PostMapping("/create")
    public AjaxResult createChange(
            @RequestBody ChangeConfigReq changeConfigReq){
        return service.createChange(changeConfigReq);
    }

    /**
     * 修改变更模板详情
     * @param changeConfigReq
     * @return
     */
    @PostMapping("/modify")
    public AjaxResult modifyChange(
            @RequestBody ChangeConfigReq changeConfigReq){
        return service.modifyChange(changeConfigReq);
    }

    /**
     * 删除模板配置
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public AjaxResult deleteChange(
            @RequestBody Long id){
        return service.deleteChange(id);
    }

    /**
     * 查询所有模板配置类型
     * @return
     */
    @GetMapping("/query/config/type")
    public AjaxResult queryConfigType(){
        return service.queryConfigType();
    }

    @Autowired
    private PfuApiRpcService pfuApiRpcService;

    @Autowired
    private ItemcenterApiRpcService itemcenterApiRpcService;


    @PostMapping("/test")
    public String queryExecuteUserByItemId(@RequestBody List<Long> goodsId){
        String detail = itemcenterApiRpcService.getDetail(goodsId);
        JSONObject jsonObject = JSONObject.parseObject(detail);
        Map<String,JSONObject> map = JSONObject.parseObject(jsonObject.get("data").toString(), Map.class);
        StringBuilder stringBuilder = new StringBuilder();
        for (String rpc : map.keySet()){
            stringBuilder.append(map.get(rpc).get("uid")+"\n");
        }
        return stringBuilder.toString();
    }

}
