/**
 * @(#)TestController.java, 2022/11/28.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.web.controller;

import java.util.List;

import com.netease.mail.yanxuan.change.biz.biz.ChangeSubFlowBiz;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeSubFlowCreateReq;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.netease.mail.yanxuan.change.biz.biz.ChangeFlowBiz;
import com.netease.mail.yanxuan.change.biz.biz.DepartmentLeaderBiz;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.rpc.QCService;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.common.bean.RequestLocalBean;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeConfigPo;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierInfoService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierRelatedUserReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierUserRsp;
import com.netease.mail.yanxuan.change.integration.qc.meta.QcCategoryVO;

import lombok.extern.slf4j.Slf4j;

import javax.validation.Valid;

/**
 * @Author zcwang
 * @Date 2022/11/28
 */
@Slf4j
@RestController
@RequestMapping("/test")
public class TestController {

    @Autowired
    private ChangeFlowBiz changeFlowBiz;

    @Autowired
    private ChangeConfigService changeConfigService;

    @Autowired
    private QCService qcService;

    @Autowired
    private ChangeSubFlowBiz changeSubFlowBiz;

    @Autowired
    private DepartmentLeaderBiz departmentLeaderBiz;

    // @PostMapping("/submit")
    // public AjaxResult<Void> submit(Long id) {
    //     ChangeRecord record = changeFlowService.getById(id);
    //     Assert.notNull(record, "工单不存在");
    //     if (!record.getFlowNode().equals(ChangeFlowEnum.CHANGE_FLOW_EXE.getNodeId())) {
    //         throw ExceptionFactory.createBiz(ResponseCode.SUBMIT_FLOW_ERROR, "不是变更执行节点，不可运维提交");
    //     }
    //     autoSubmit.progressRecord(record);
    //     return AjaxResult.success();
    // }

    @GetMapping("/getUid")
    public AjaxResult<String> getUid() {
        return AjaxResult.success(RequestLocalBean.getUid());
    }

    @Autowired
    private FlowRpcSupplierInfoService supplierInfoService;

    @PostMapping("/test")
    public List<SupplierUserRsp> test(@RequestBody SupplierRelatedUserReq req) {
        return supplierInfoService.querySupplierRelatedUser(req);
    }

    // @PostMapping("/send")
    // public void sendEmail(@RequestBody SendMailReq req) {
    //     String subjectParam = req.getId().toString();
    //     EmailTemplateEnum emailTemplateEnum = EmailTemplateEnum.getEmailTemplateEnum(req.getCode());
    //     String mapToJson = req.getMapToJson();
    //     log.debug("[testSendEmail] subjectParam:{}, emailTemplateEnum:{}, mapToJson:{}", subjectParam,
    //         emailTemplateEnum, mapToJson);
    //     changeFlowBiz.qcSendEmail(appConfig.getReceiver(), appConfig.getReceiver(), subjectParam,
    //                     emailTemplateEnum, JSON.parseObject(mapToJson, Map.class));
    //     // 如果是供应商，再次发送供应商邮件
    //     if (req.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
    //         Assert.notNull(req.getChangeSupplier(), "同舟端负责人不可为空");
    //         sendSupplierEmail.sendSupplierEmail(req.getChangeSupplier(), subjectParam,
    //                 emailTemplateEnum, JSON.parseObject(mapToJson, Map.class));
    //     }
    // }

    @GetMapping("/ccList")
    public AjaxResult<List<String>> ccList(@RequestParam List<String> receiver){
        return AjaxResult.success(departmentLeaderBiz.getDepartmentLeaders(receiver));
    }

    @GetMapping("/getByOneAndTwo")
    public AjaxResult<ChangeConfigPo> getByOneAndTwo(@RequestParam Long parentId, @RequestParam Long sonId) {
        return AjaxResult.success(changeConfigService.queryInfoPo(parentId, sonId));
    }

    @GetMapping("/getQc")
    public AjaxResult<List<QcCategoryVO>> getQc(@RequestParam("itemId") Long itemId) {
        return AjaxResult.success(qcService.getQcCategoryListByItemId(itemId));
    }

    /**
     * 发起变更执行工单
     *
     * @return
     */
    @PostMapping("/create")
    public AjaxResult<String> createAndSubmit(@RequestBody @Valid ChangeSubFlowCreateReq changeSubFlowCreateReq) {
        return AjaxResult.success(changeSubFlowBiz.createAndSubmit(changeSubFlowCreateReq));
    }
}