/**
 * @(#)ChangeFlowEnum.java, 2022/11/16.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.common.enums;

import lombok.Getter;

/**
 * @Author zcwang
 * @Date 2022/11/16
 */
public enum ChangeFlowEnum {

    CHANGE_FLOW("0000", "全链路变更", "qc-change-flow"),
    CHANGE_FLOW_START("79560500", "开始节点", "qc-change-flow"),
    CHANGE_FLOW_SUBMIT("79560501", "变更申请提交", "qc-change-flow"),
    CHANGE_FLOW_EXE("79560502","变更执行", "qc-change-flow"),
    CHANGE_FLOW_CONFIRM("79560503","变更结果确认", "qc-change-flow"),
    END("9999", "结束", "qc-change-flow");

    @Getter
    private final String nodeId;

    private final String name;

    @Getter
    private final String topoId;

    ChangeFlowEnum(String nodeId, String name, String topoId) {
        this.nodeId = nodeId;
        this.name = name;
        this.topoId = topoId;
    }

    public static ChangeFlowEnum getByNodeId(String nodeId) {
        for (ChangeFlowEnum value : ChangeFlowEnum.values()) {
            if (value.getNodeId().equals(nodeId)) {
                return value;
            }
        }
        return null;
    }
}