package com.netease.mail.yanxuan.change.common.constants;

/**
 * 工单流转类型常量
 * 用于 paramMap 中的 type 参数，控制 topo 图的流转方向
 * 统一规则：1=通过，2=取消，3=回退，4=跳过
 * 
 * @Author AI Assistant
 * @Date 2025/01/04
 */
public class FlowTransitionType {
    
    /**
     * 类型1：通过/前进到下一节点
     */
    public static final Integer TYPE_APPROVED = 1;
    
    /**
     * 类型2：取消
     */
    public static final Integer TYPE_CANCEL = 2;
    
    /**
     * 类型3：回退
     */
    public static final Integer TYPE_BACK = 3;
    
    /**
     * 类型4：跳过
     */
    public static final Integer TYPE_SKIP = 4;
    
    private FlowTransitionType() {
        // 工具类，禁止实例化
    }
}

