/**
 * @(#)ChangeExecRecordMapper.java, 2022/11/11.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;

/**
 * @Author zcwang
 * @Date 2022/11/11
 */
@Mapper
public interface ChangeExecRecordMapper extends tk.mybatis.mapper.common.Mapper<ChangeExecRecord> {


    @Select("SELECT * FROM TB_YX_QC_CHANGE_EXEC_RECORD WHERE change_record_id = #{changeRecordId}")
    List<ChangeExecRecord> selectByChangeRecordId(@Param("changeRecordId") Long id);

    @Insert({ "<script>",
        "insert into TB_YX_QC_CHANGE_EXEC_RECORD(change_record_id, change_exec_department, change_exec_user_type, change_exec_user, change_risk_desc,change_exec_project, change_checking, change_exec_finish_time, change_exec_finish_desc, create_time, update_time) values ",
        "<foreach collection='list' item='item' index='index' separator=','>",
        "(#{item.changeRecordId}, #{item.changeExecDepartment}, #{item.changeExecUserType}, #{item.changeExecUser}, #{item.changeRiskDesc}, #{item.changeExecProject}, #{item.changeChecking}, #{item.changeExecFinishTime}, #{item.changeExecFinishDesc}, #{item.createTime}, #{item.updateTime})",
        "</foreach>", "</script>" })
    void insertList(@Param("list") List<ChangeExecRecord> changeExecRecordList);

    @Delete("delete from TB_YX_QC_CHANGE_EXEC_RECORD where change_record_id = #{changeRecordId}")
    Integer deleteByBaseId(@Param("changeRecordId") Long changeRecordId);

    @Select("SELECT DISTINCT(change_record_id) FROM TB_YX_QC_CHANGE_EXEC_RECORD WHERE change_exec_user_email LIKE #{changeExecUser}")
    List<Long> queryByUser(@Param("changeExecUser") String changeExecUser);
}
