/**
 * @(#)ChangeExecRecord.java, 2022/11/11.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.entity;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author zcwang
 * @Date 2022/11/11
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
@Entity
@Table(name = "TB_YX_CHANGE_EXEC_RECORD")
public class ChangeExecRecord {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 变更记录id
     */
    private Long changeRecordId;

    /**
     * 变更执行部门名
     */
    private String changeExecDepartment;

    /**
     * 变更行动人类型
     */
    private Integer changeExecUserType;

    /**
     * 变更行动人（不同类型存储不同内容）
     */
    private String changeExecUser;

    /**
     * 变更风险描述
     */
    private String changeRiskDesc;

    /**
     * 行动项
     */
    private String changeExecProject;

    /**
     * 变更措施验证
     */
    private String changeChecking;

    /**
     * 行动完成时间
     */
    private Long changeExecFinishTime;

    /**
     * 行动完成情况
     */
    private String changeExecFinishDesc;

    /**
     * 创建时间
     */
    private Long createTime;

    /**
     * 更新时间
     */
    private Long updateTime;
}