package com.netease.mail.yanxuan.change.web.controller;

import com.netease.mail.yanxuan.change.biz.meta.AjaxResult;
import com.netease.mail.yanxuan.change.biz.service.AdminChangeConfigService;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeConfigMapper;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeExecConfigMapper;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeTypeMapper;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigReq;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@RequestMapping
@RestController("/config/change")
public class ChangeConfigController {

    @Autowired
    private ChangeConfigMapper changeConfigMapper;

    @Autowired
    private ChangeExecConfigMapper changeExecConfigMapper;

    @Autowired
    private ChangeTypeMapper changeTypeMapper;


    @Autowired
    private AdminChangeConfigService service;


    @GetMapping("/list")
    public AjaxResult queryChanges(
            @RequestBody ChangeConfigQueryReq changeConfigQueryReq){
        return service.queryChanges(changeConfigQueryReq);
    }

    @GetMapping("/detail")
    public AjaxResult queryDetail(
            @RequestParam(name = "id",required = false) Long id,
            @RequestParam(name = "sonChangeClassId",required = false) Long sonChangeClassId){

        return service.queryDetail(id, sonChangeClassId);
    }

    @PostMapping("/create")
    public AjaxResult createChange(
            @RequestBody ChangeConfigReq changeConfigReq){

        return service.createChange(changeConfigReq);
    }

    @PostMapping("/modify")
    public AjaxResult modifyChange(
            @RequestBody ChangeConfigReq changeConfigReq){

        return service.modifyChange(changeConfigReq);
    }

    @PostMapping("/delete")
    public AjaxResult deleteChange(
            @RequestBody Long id){

        return service.deleteChange(id);
    }










}
