/**
 * @(#)ChangeRecordMapper.java, 2022/11/11.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowListQueryReq;

/**
 * @Author zcwang
 * @Date 2022/11/11
 */
@Mapper
public interface ChangeRecordMapper extends tk.mybatis.mapper.common.Mapper<ChangeRecord> {

    @Select("select * from TB_YX_QC_CHANGE_RECORD where `flow_id` = #{flowId}")
    ChangeRecord selectByFlowId(@Param("flowId") Long flowId);

    List<ChangeRecord> selectByCondition(ChangeFlowListQueryReq changeFlowListQueryReq);

    @Select("select * from TB_YX_QC_CHANGE_RECORD where id > #{entityId} and `flowNode` in (#{nodeId1}, #{nodeId2}) and changeConfirmResultTime <= #{currentTime} limit 200")
    List<ChangeRecord> getByStatusAndTime(@Param("entityId") Long entityId, @Param("nodeId1") String nodeId1,
                                          @Param("nodeId2") String nodeId2, @Param("currentTime") long currentTime);
}
