package com.netease.mail.yanxuan.change.biz.biz;

import com.netease.mail.yanxuan.change.biz.service.rpc.IusService;
import com.netease.mail.yanxuan.change.integration.flow.ius.req.IusDepartmentReq;
import com.netease.mail.yanxuan.change.integration.flow.ius.rsp.SecondaryDepartments;
import com.netease.mail.yanxuan.change.integration.flow.ius.rsp.leaderChain;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 部门领导查询业务类
 * 
 * @author system
 */
@Component
@Slf4j
public class DepartmentLeaderBiz {

    @Autowired
    private IusService iusService;

    /**
     * 批量获取用户的部门上级领导列表
     * 
     * @param userEmails 用户邮箱列表
     * @return 上级领导邮箱列表（去重）
     */
    public List<String> getDepartmentLeaders(List<String> userEmails) {
        if (CollectionUtils.isEmpty(userEmails)) {
            return new ArrayList<>();
        }
        
        IusDepartmentReq iusDepartmentReq = new IusDepartmentReq();
        iusDepartmentReq.setHasOrgPos(true);
        iusDepartmentReq.setIcac(true);
        iusDepartmentReq.setUids(userEmails);
        
        HashMap<String, List<SecondaryDepartments>> map = iusService.queryDepartment(iusDepartmentReq);
        ArrayList<List<SecondaryDepartments>> secondaryDepartments = new ArrayList<>(map.values());
        List<String> leaderList = new ArrayList<>();
        
        if (CollectionUtils.isNotEmpty(secondaryDepartments)) {
            // 外层循环是不同人，内层循环是相同人不同部门
            for (List<SecondaryDepartments> secondaryDepartment : secondaryDepartments) {
                for (SecondaryDepartments dep : secondaryDepartment) {
                    List<leaderChain> leaderChainList = dep.getLeaderChainList();
                    if (CollectionUtils.isNotEmpty(leaderChainList)) {
                        // 获取上一级领导（leaderChainList 的最后一个元素，列表是从上往下逐级下降的：最上级 -> ... -> 上一级）
                        leaderChain directLeader = leaderChainList.get(leaderChainList.size() - 1);
                        if (directLeader != null && StringUtils.isNotBlank(directLeader.getUid())) {
                            leaderList.add(directLeader.getUid());
                        }
                    }
                }
            }
        }
        
        // 去重
        if (CollectionUtils.isNotEmpty(leaderList)) {
            leaderList = leaderList.stream().distinct().collect(Collectors.toList());
        }
        
        return leaderList;
    }

    /**
     * 获取单个用户的部门上级领导（取第一个）
     * 
     * @param userEmail 用户邮箱
     * @return 上级领导邮箱，如果不存在则返回 null
     */
    public String getDepartmentLeader(String userEmail) {
        if (StringUtils.isBlank(userEmail)) {
            return null;
        }
        
        List<String> leaders = getDepartmentLeaders(Collections.singletonList(userEmail));
        if (CollectionUtils.isNotEmpty(leaders)) {
            return leaders.get(0);
        }
        
        return null;
    }
}

