package com.netease.mail.yanxuan.change.biz.service;

import java.util.List;

import com.netease.mail.yanxuan.change.common.enums.FileTypeEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeSubFlowFile;

/**
 * 子单文件服务
 */
public interface ChangeSubFlowFileService {

    /**
     * 保存文件
     */
    void saveRecord(ChangeSubFlowFile file);

    /**
     * 批量保存文件
     */
    void batchSaveRecord(List<ChangeSubFlowFile> files);

    /**
     * 根据子单记录ID查询文件列表
     */
    List<ChangeSubFlowFile> getFileList(Long subFlowRecordId);

    /**
     * 根据子单记录ID删除文件
     */
    Integer deleteBySubFlowRecordId(Long subFlowRecordId);

    /**
     * 根据子单记录ID和文件类型删除文件
     */
    void deleteBySubFlowRecordIdAndType(Long subFlowRecordId, FileTypeEnum type);
}

