/**
 * @(#)ChangeFlowListQueryReq.java, 2022/11/21.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.req;

import com.netease.mail.yanxuan.change.common.enums.CreateSourceEnum;

import lombok.Data;

import java.util.List;

/**
 * @Author zcwang
 * @Date 2022/11/21
 */
@Data
public class ChangeFlowListQueryReq {
    /**
     * 变更商品（变更主体为商品时有效）
     */
    private String itemId;

    private String skuId;

    /**
     * 变更供应商（变更主体为供应商时有效）
     */
    private String supplier;

    /**
     * 一级变更类型id
     */
    private Long parentChangeClassId;

    /**
     * 二级变更类型id
     */
    private Long sonChangeClassId;

    /**
     * 工单状态
     */
    private Integer changeState;

    /**
     * 变更负责人
     */
    private String changeCommander;

    /**
     * 变更负责部门名
     */
    private String changeDepartment;

    /**
     * 变更行动部门
     */
    private String changeExecDepartment;

    /**
     * 开始时间
     */
    private Long startTime;

    /**
     * 结束时间
     */
    private Long endTime;

    /**
     * 创建端
     * @see CreateSourceEnum
     */
    private Integer createSource;

    /**
     * 创建端
     */
    private String createSupplier;

    /**
     * 变更执行人
     */
    private String changeExecUser;

    /**
     * 变更记录id集合
     */
    private List<Long> changeRecordIds;

    /**
     * 工单id
     */
    private Long flowId;

    /**
     * 数据可见范围：仅查看我跟进的工单（默认true）
     * true: 仅展示 "变更申请人/变更负责人/变更审批人=当前用户" 的变更工单
     * false: 展示所有工单
     */
    private Boolean onlyMyFollowed;

    /**
     * 当前用户邮箱（用于数据可见范围过滤）
     */
    private String currentUser;

    private Long limit;

    private Long offset;
}