/**
 * @(#)ChangeRecord.java, 2022/11/11.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.entity;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author zcwang
 * @Date 2022/11/11
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
@Entity
@Table(name = "TB_YX_QC_CHANGE_RECORD")
public class ChangeRecord {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 工单id
     */
    private Long flowId;

    /**
     * 工单当前节点
     */
    private String flowNode;

    /**
     * 变更主体
     */
    private Integer changeSubject;

    /**
     * 一级变更类型id
     */
    private Long parentChangeClassId;

    /**
     * 二级变更类型id
     */
    private Long sonChangeClassId;

    /**
     * 变更等级
     */
    private Integer changeLevel;

    /**
     * 变更负责人
     */
    private String changeCommander;

    /**
     * 变更负责部门名
     */
    private String changeDepartment;

    /**
     * 参与变更行动部门，json格式，查询用
     */
    private String participateChangeExecDepartment;

    /**
     * 变更商品（变更主体为商品时有效）
     */
    private String changeItem;

    /**
     * 变更供应商（变更主体为供应商时有效）
     */
    private String changeSupplier;

    /**
     * 变更原因
     */
    private String changeReason;

    /**
     * 变更内容
     */
    private String changeContent;

    /**
     * 变更潜在风险描述
     */
    private String changeRiskDesc;

    /**
     * 变更验证措施
     */
    private String changeChecking;

    /**
     * 变更收益类型
     */
    private Integer changeProfit;

    /**
     * 变更收益说明
     */
    private String changeProfitDesc;

    /**
     * 变更结果确认时间
     */
    private Long changeConfirmResultTime;

    /**
     * 工单状态
     */
    private Integer state;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 变更结论
     */
    private Integer changeResult;

    /**
     * 创建端（普通or同舟）
     */
    private Integer createSource;

    /**
     * 创建人所属供应商（同舟创建）
     */
    private String createSupplier;

    /**
     * 结论说明
     */
    private String changeResultDesc;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人邮箱
     */
    private String creator;

    /**
     * 待办id
     */
    private Integer todoId;

    /**
     * 自动执行邮件发送
     */
    private Integer autoSubmitEmail;

    /**
     * 创建时间
     */
    private Long createTime;

    /**
     * 更新时间
     */
    private Long updateTime;
}