/**
 * @(#)AppConfig.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.config;

import java.util.List;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.ctrip.framework.apollo.spring.annotation.EnableAutoUpdateApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ValueMapping;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
@Component
@EnableAutoUpdateApolloConfig("application")
@Data
public class AppConfig {

    @ValueMapping("${titleConfig:null}")
    private TitleConfig titleConfig;

    @Value("${changeExecLimit:20}")
    private Integer changeExecLimit;

    /**
     * 商品关联开发兜底人名
     */
    @Value("${change.goods.functionary.name:钱伟钰}")
    private String functionaryName;

    /**
     * 商品关联开发兜底邮箱
     */
    @Value("${change.goods.functionary.email:qianweiyu@corp.netease.com}")
    private String functionaryEmail;

    /**
     * 商品关联采购兜底人名
     */
    @Value("${change.goods.purchase.name:陈金灿}")
    private String purchaseName;

    /**
     * 商品关联采购兜底邮箱
     */
    @Value("${change.goods.purchase.email:bjchenjincan@corp.netease.com}")
    private String purchaseEmail;
    /**
     * 商品关联计划兜底人名
     */
    @Value("${change.goods.project.name:王敏}")
    private String goodsProjectName;

    /**
     * 商品关联计划兜底邮箱
     */
    @Value("${change.goods.project.email:wangmin12@corp.netease.com}")
    private String goodsProjectEmail;

    /**
     * 商品关联SQE兜底邮箱
     */
    @Value("${change.goods.sqe.name:崔亦仙}")
    private String sqeName;

    /**
     * 商品关联SQE兜底邮箱
     */
    @Value("${change.goods.sqe.email:cuiyixian@corp.netease.com}")
    private String sqeEmail;

    /**
     * 商品关联合规兜底人名
     */
    @Value("${change.goods.compliance.name:}")
    private String complianceName;

    /**
     * 商品关联合规兜底邮箱
     */
    @Value("${change.goods.compliance.email:}")
    private String complianceEmail;

    /**
     * 变更管理QM
     */
    @Value("${changeManageQM:cuiyixian@corp.netease.com}")
    private String changeManageQM;
    
    /**
     * 变更管理员（用于主单审批流程）
     */
    @Value("${changeAdmin:wb.xietao@mesg.corp.netease.com}")
    private String changeAdmin;
    
    /**
     * 质量部负责人（用于主单审批流程）
     */
    @Value("${changeQualityLeader:wb.xietao@mesg.corp.netease.com}")
    private String changeQualityLeader;

    /**
     * 变更管理委员会
     */
    @Value("${changeCommittee:yx_change_SC@qun.mail.163.com}")
    private String changeCommittee;

    @Value("${exportLimit:20}")
    private Long exportLimit;

    /**
     * 需要审批的部门列表（只有这些部门的行动工单需要审批，其他部门自动通过）
     * 配置格式：部门名称列表，逗号分隔，例如：质量部,研发部
     */
    @ValueMapping("${changeSubflowNeedApproveDepartments:[]}")
    private List<String> needApproveDepartments;
    
    /**
     * 工单超期判断的工作日数（默认2天）
     */
    @Value("${change.overdue.workdays:2}")
    private Integer overdueWorkdays;
}