package com.netease.mail.yanxuan.change.biz.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.netease.mail.yanxuan.change.biz.service.ISupplierItemService;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierGoodsInfoReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierGoodsInfoRsp;
import com.netease.mail.yanxuan.change.integration.item.ItemRpcService;
import com.netease.mail.yanxuan.change.integration.item.meta.SkuSpecTO;
import com.netease.mail.yanxuan.change.integration.item.meta.SkuSpecValueTO;
import com.netease.mail.yanxuan.change.integration.item.meta.SkuTo;
import com.netease.mail.yanxuan.change.integration.item.meta.SpuTO;
import com.netease.mail.yanxuan.change.integration.item.param.BatchQuerySpuInfoParam;
import com.netease.mail.yanxuan.change.integration.todo.PageVO;
import com.netease.mail.yanxuan.change.integration.todo.SupplierItemPageVO;
import com.netease.mail.yanxuan.change.integration.todo.SupplierItemSkuVO;
import com.netease.mail.yanxuan.change.integration.todo.SupplierItemVO;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;

import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
public class SupplierItemServiceImpl implements ISupplierItemService {

    @Autowired
    private FlowRpcSupplierSendService flowRpcSupplierSendService;

    @Autowired
    private ItemRpcService itemRpcService;

    @Override
    public SupplierItemPageVO supplierGoodsInfoBySupplier(SupplierGoodsInfoReq supplierGoodsInfoReq, String itemId,
        String itemName, Integer page, Integer pageSize, String skuId) {
        AjaxResponse<List<SupplierGoodsInfoRsp>> listAjaxResponse = flowRpcSupplierSendService
            .supplierGoodsInfoBySupplier(supplierGoodsInfoReq);
        List<SupplierGoodsInfoRsp> data = listAjaxResponse.getData();
        List<SpuTO> spuTOList = new ArrayList<>();
        if (data != null) {
            Set<Long> fullItemIds = data.stream().map(SupplierGoodsInfoRsp::getItemId).collect(Collectors.toSet());
            log.debug("[op:supplierGoodsInfoBySupplier] fullItemIds: {}", fullItemIds);
            while (fullItemIds.size() > 200) {
                List<Long> itemIds = new ArrayList<>(fullItemIds).subList(0, 200);
                List<String> commonProps = new ArrayList<>();
                commonProps.add("sku");
                commonProps.add("skuSpec");
                AjaxResult<List<SpuTO>> listAjaxResult = itemRpcService
                    .batchQuerySpuInfo(BatchQuerySpuInfoParam.builder().ids(itemIds).commonProps(commonProps).build());
                List<SpuTO> pageSpuTo = listAjaxResult.getData();
                if (!CollectionUtils.isEmpty(pageSpuTo)) {
                    spuTOList.addAll(pageSpuTo);
                }
                fullItemIds.removeAll(itemIds);
            }
            List<Long> itemIds = new ArrayList<>(fullItemIds);
            AjaxResult<List<SpuTO>> listAjaxResult = itemRpcService
                .batchQuerySpuInfo(BatchQuerySpuInfoParam.builder().ids(itemIds).build());
            List<SpuTO> pageSpuTo = listAjaxResult.getData();
            if (!CollectionUtils.isEmpty(pageSpuTo)) {
                spuTOList.addAll(pageSpuTo);
            }
        }
        if (StringUtils.isNotBlank(itemId)) {
            spuTOList = spuTOList.stream().filter(i -> Long.valueOf(itemId).equals(i.getId()))
                .collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank(itemName)) {
            spuTOList = spuTOList.stream().filter(i -> i.getName().contains(itemName)).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank(skuId)) {
            spuTOList = spuTOList.stream().filter(obj -> !CollectionUtils.isEmpty(obj.getSkuList())).filter(i -> {
                List<Long> skuIds = i.getSkuList().stream().map(SkuTo::getId).collect(Collectors.toList());
                if (skuIds.contains(Long.valueOf(skuId))) {
                    return Boolean.TRUE;
                } else {
                    return Boolean.FALSE;
                }
            }).collect(Collectors.toList());
        }
        PageVO pageVO = buildPageVo(spuTOList.size(), page, pageSize);
        Integer endIndex = page * pageSize;
        if (page * pageSize > spuTOList.size()) {
            endIndex = spuTOList.size();
        }
        List<SpuTO> pageItem = spuTOList.subList((page - 1) * pageSize, endIndex);
        List<SupplierItemVO> supplierItemVOList = pageItem.stream().map(i -> {
            SupplierItemVO supplierItemVO = new SupplierItemVO();
            supplierItemVO.setItemId(i.getId());
            supplierItemVO.setItemName(i.getName());
            supplierItemVO.setSpecList(i.getSpecList());
            List<SupplierItemSkuVO> skuVOList = i.getSkuList().stream().map(s -> {
                SupplierItemSkuVO supplierItemSkuVO = new SupplierItemSkuVO();
                supplierItemSkuVO.setSkuId(s.getId());
                supplierItemSkuVO.setSkuName(s.getDisplayName());
                supplierItemSkuVO.setSkuSpecCombine(s.getSkuSpecCombine());
                return supplierItemSkuVO;
            }).collect(Collectors.toList());
            supplierItemVO.setSkuInfoVOS(skuVOList);
            return supplierItemVO;
        }).collect(Collectors.toList());

        supplierItemVOList.forEach(i -> {
            List<SkuSpecTO> specList = i.getSpecList();
            i.getSkuInfoVOS().forEach(s -> {
                StringBuilder displayString = new StringBuilder();
                s.getSkuSpecCombine().forEach(spec -> {
                    Optional<SkuSpecTO> any = specList.stream().filter(sp -> sp.getId() == spec.getSkuSpecId())
                        .findAny();
                    if (any.isPresent()) {
                        Optional<SkuSpecValueTO> anySpecValue = any.get().getSpecValueList().stream()
                            .filter(speValue -> speValue.getId() == spec.getSkuSpecValueId()).findAny();
                        anySpecValue.ifPresent(skuSpecValueTO -> displayString.append(skuSpecValueTO.getValue()));
                    }
                });
                s.setDisplayString(displayString.toString());
            });
        });

        return SupplierItemPageVO.builder().pageVo(pageVO).supplierItemVOList(supplierItemVOList).build();
    }

    private PageVO buildPageVo(int size, Integer page, Integer pageSize) {
        int totalPage = size % pageSize == 0 ? size / pageSize : size / pageSize + 1;
        return PageVO.builder().page(page).pageSize(pageSize).totalCount(size).totalPage(totalPage).build();
    }
}
