package com.netease.mail.yanxuan.change.biz.service;

import java.util.List;
import java.util.Map;

import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeCommanderPO;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeGoodsPrincipalPO;
import com.netease.mail.yanxuan.change.dal.meta.model.po.QueryCommanderEmailReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowCreateReq;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.CommanderResponse;
import com.netease.mail.yanxuan.change.dal.meta.model.rpc.GoodsResponseRpc;

/**
 * @author WangJiaXiang
 * @date 2022/11/18/018$
 * 内部服务接口
 */
public interface InteriorChangeConfigService {

    /**
     * 根据变更信息 返回住变更负责人
     * @param changeCommander
     * @return
     */
    GoodsResponseRpc queryCommanderInfo(ChangeCommanderPO changeCommander);

    /**
     * 传入商品列表 返回商品信息
     * @param itemIds
     * @return
     */
    Map<Long, ChangeGoodsPrincipalPO> queryGoodsPrincipalInfo(List<Long> itemIds);

    /**
     * 查询负责人信息
     * @param req
     * @return
     */
    CommanderResponse queryCommanderEmail(QueryCommanderEmailReq req);

}
