package com.netease.mail.yanxuan.change.biz.callback;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.netease.mail.dp.des.process.api.entity.CallbackQueryReq;
import com.netease.mail.dp.des.process.api.entity.ExcelCell;
import com.netease.mail.dp.des.process.api.entity.ExcelTitle;
import com.netease.mail.dp.des.starter.callback.DesCallbackService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeTypeService;
import com.netease.mail.yanxuan.change.common.enums.ChangeLevelEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeCommanderEnum;
import com.netease.mail.yanxuan.change.common.enums.NeedFileEnum;
import com.netease.mail.yanxuan.change.common.util.DateUtils;
import com.netease.mail.yanxuan.change.common.util.ExcelUtil;
import com.netease.mail.yanxuan.change.dal.entity.ChangeType;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeConfigMapper;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeConfigPo;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigQueryReq;
import com.netease.mail.yanxuan.change.integration.excel.ChangeConfigExcelDTO;
import com.netease.mail.yanxuan.change.integration.excel.ChangeConfigExcelVo;

import lombok.extern.slf4j.Slf4j;

/**
 * 变更配置导出回调
 */
@Slf4j
@Component
public class ChangeConfigExportCallback implements DesCallbackService {

    @Autowired
    private ChangeConfigMapper changeConfigMapper;
    
    @Autowired
    private ChangeTypeService changeTypeService;

    @Override
    public ExcelTitle queryExcelTitle(CallbackQueryReq req) {
        log.info("[op: change config export callback queryExcelTitle] req={}", JSON.toJSONString(req));
        ChangeConfigQueryReq query = JSON.parseObject(req.getParamJson(), ChangeConfigQueryReq.class);
        
        List<ChangeConfigPo> list = changeConfigMapper.selectChangeConfigPo(query);
        ExcelTitle excelTitle = ExcelUtil.fetchExceltile(ChangeConfigExcelVo.class);
        excelTitle.setTotal((long) list.size());
        log.info("[op: change config export callback queryExcelTitle] result={}", JSON.toJSONString(excelTitle));
        return excelTitle;
    }

    @Override
    public List<List<ExcelCell>> queryExcelData(CallbackQueryReq req) {
        log.info("[op: change config export callback queryExcelData] req={}", JSON.toJSONString(req));
        ChangeConfigQueryReq query = JSON.parseObject(req.getParamJson(), ChangeConfigQueryReq.class);
        query.setOffset(req.getOffset());
        query.setLimit(req.getLimit());
        List<ChangeConfigExcelDTO> list = getExportList(query);
        log.debug("[op: change config export callback queryExcelData] size:{}", list.size());
        return list.stream().map(ChangeConfigExcelVo::init).collect(Collectors.toList());
    }

    @Override
    public com.netease.mail.dp.des.process.api.entity.PivotTable queryPivotTable(CallbackQueryReq req) {
        // 不需要透视表，返回null
        return null;
    }

    private List<ChangeConfigExcelDTO> getExportList(ChangeConfigQueryReq query) {
        List<ChangeConfigPo> changeConfigPos = changeConfigMapper.selectChangeConfigPo(query);
        
        // 处理执行部门格式
        changeConfigPos.forEach(i -> {
            if (StringUtils.isNotBlank(i.getParticipateChangeExecDepartment())) {
                String replaceDep = i.getParticipateChangeExecDepartment().replace("[", "").replace("]", "").replace(" ", "");
                List<String> depList = Arrays.stream(replaceDep.split(","))
                        .filter(StringUtils::isNotBlank)
                        .distinct()
                        .collect(Collectors.toList());
                i.setParticipateChangeExecDepartment(Joiner.on(",").join(depList));
            }
        });
        
        return changeConfigPos.stream().map(po -> {
            ChangeConfigExcelDTO dto = new ChangeConfigExcelDTO();
            dto.setId(po.getId());
            
            // 变更主体
            if (po.getChangeSubject() != null) {
                dto.setChangeSubject(ChangeSubjectEnum.getChangeSubjectEnum(po.getChangeSubject()) != null 
                        ? ChangeSubjectEnum.getChangeSubjectEnum(po.getChangeSubject()).getDesc() : "");
            }
            
            // 变更类型
            String parentChangeType = "";
            String sonChangeType = "";
            if (po.getParentChangeClassId() != null && po.getSonChangeClassId() != null) {
                ChangeType parentType = changeTypeService.getChangeTypeById(po.getParentChangeClassId().longValue());
                ChangeType sonType = changeTypeService.getChangeTypeById(po.getSonChangeClassId().longValue());
                if (parentType != null) {
                    parentChangeType = parentType.getTypeName();
                }
                if (sonType != null) {
                    sonChangeType = sonType.getTypeName();
                }
            }
            dto.setParentChangeType(parentChangeType);
            dto.setSonChangeType(sonChangeType);
            
            // 变更等级
            if (po.getChangeLevel() != null) {
                dto.setChangeLevel(ChangeLevelEnum.getByType(po.getChangeLevel()));
            }
            
            dto.setChangeDepartment(po.getChangeDepartment());
            dto.setParticipateChangeExecDepartment(po.getParticipateChangeExecDepartment());
            
            // 变更负责人类型
            if (po.getChangeCommanderType() != null) {
                ChangeCommanderEnum commanderEnum = ChangeCommanderEnum.getChangeCommanderEnum(po.getChangeCommanderType());
                dto.setChangeCommanderType(commanderEnum != null ? commanderEnum.getName() : "");
            }
            
            dto.setChangeCommander(po.getChangeCommander());
            
            // 是否需要资料
            if (po.getNeedFile() != null) {
                String needFileDesc = "";
                for (NeedFileEnum needFileEnum : NeedFileEnum.values()) {
                    if (needFileEnum.getStatus().equals(po.getNeedFile())) {
                        needFileDesc = needFileEnum.getDesc();
                        break;
                    }
                }
                dto.setNeedFile(needFileDesc);
            }
            
            dto.setCreator(po.getCreator());
            
            // 时间格式化
            if (po.getCreateTime() != null) {
                dto.setCreateTime(DateUtils.parseLongToString(po.getCreateTime(), DateUtils.DATE_TIME_FORMAT));
            }
            if (po.getUpdateTime() != null) {
                dto.setUpdateTime(DateUtils.parseLongToString(po.getUpdateTime(), DateUtils.DATE_TIME_FORMAT));
            }
            
            return dto;
        }).collect(Collectors.toList());
    }
}

