/**
 * @(#)TestController.java, 2022/11/28.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.web.controller;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.service.rpc.TodoService;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierSearchRemoteReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierSimpleRsp;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/28
 */
@Slf4j
@RestController
@RequestMapping("/test")
public class TestController {

    @Autowired
    private TodoService todoService;

    @PostMapping("/createToDo")
    public AjaxResult<Void> createTodoTask(ChangeRecord entity) {
        log.info("[createToDoTask] entity:{}", JSON.toJSONString(entity));
        todoService.createTodoTask(entity);
        return AjaxResult.success();
    }

    @PostMapping("/progressTodo")
    public AjaxResult<Void> progressTodoTask(ChangeRecord entity, Integer operateType) {
        log.info("[createToDoTask] entity:{}, operateType:{}", JSON.toJSONString(entity), operateType);
        todoService.progressTodoTask(entity, operateType);
        return AjaxResult.success();
    }

    @Autowired
    private FlowRpcSupplierSendService service;

    @PostMapping("/test")
    public AjaxResponse<List<SupplierSimpleRsp>> test1(@RequestParam String name){
        SupplierSearchRemoteReq req = new SupplierSearchRemoteReq();
        req.setSearchText(name);
        return service.queryByConditionForQc(req);
    }

    @GetMapping("/query/supplier/infos")
    public AjaxResponse<List<SupplierSimpleRsp>> queryByConditionForQc(@RequestParam(name = "searchText") String searchText){
        SupplierSearchRemoteReq req = new SupplierSearchRemoteReq();
        req.setSearchText(searchText);
        //暂时使用模拟数据
        //AjaxResponse<List<SupplierSimpleRsp>> listAjaxResponse = service.queryByConditionForQc(req);
        AjaxResponse<List<SupplierSimpleRsp>> listAjaxResponse = new AjaxResponse<List<SupplierSimpleRsp>>();
        List<SupplierSimpleRsp> suppliers = new ArrayList<>();
        SupplierSimpleRsp supplierSimpleRsp1 = new SupplierSimpleRsp("YX0778","gyhtest1009");
        SupplierSimpleRsp supplierSimpleRsp2 = new SupplierSimpleRsp("YX0528","gyhtest1010");
        suppliers.add(supplierSimpleRsp1);
        suppliers.add(supplierSimpleRsp2);
        listAjaxResponse.setData(suppliers);
        listAjaxResponse.setCode(200);
        //return supplierSendService.queryByConditionForQc(req);  暂用模拟数据
        return listAjaxResponse;
    }
}