package com.netease.mail.yanxuan.change.web.config;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * @author zhangbingQAQ
 * @date 2021/8/27 10:18
 */
@Configuration
public class WebMvcConfig extends WebMvcConfigurerAdapter {

    @Autowired
    private LoginInterceptor loginInterceptor;

    /**
     * 拦截器配置
     *
     * @param registry
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(loginInterceptor).addPathPatterns("/**")
                .excludePathPatterns("/i/health")
                .excludePathPatterns("/getHeliosCacheConfig")
                .excludePathPatterns("/getDistributedCacheSchedule")
                .excludePathPatterns("/getLocalCacheSchedule")
                .excludePathPatterns("/nameSpace")
                .excludePathPatterns("/loadEnvClusterInfo")
                .excludePathPatterns("/test/**")
                .excludePathPatterns("/sdk/resultForCacheKey")
                .excludePathPatterns("/sdk/reportDispatchResult")
                .excludePathPatterns("/sdk/getOpMessage")
                .excludePathPatterns("/sdk/opMessageResp")
                .excludePathPatterns("/openapi/control/**")
                .excludePathPatterns("/sacs/ape/callback");
        super.addInterceptors(registry);
    }


    @Bean
    public ThreadPoolTaskExecutor mvcTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(10);
        executor.setQueueCapacity(100);
        executor.setMaxPoolSize(25);
        return executor;

    }

    //配置异步支持，设置了一个用来异步执行业务逻辑的工作线程池，设置了默认的超时时间是60秒
    @Override
    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
        configurer.setTaskExecutor(mvcTaskExecutor());
        configurer.setDefaultTimeout(apolloConfig.getLongPollingTimeout());
    }
}
